/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.text.DecimalFormat;
import java.util.List;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandAutonumberResume
extends SingleLineCommand<SequenceDiagram> {
    public CommandAutonumberResume() {
        super("(?i)^autonumber[%s]*resume(?:[%s]+(\\d+))?(?:[%s]+[%g]([^%g]+)[%g])?[%s]*$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, List<String> arg) {
        String inc;
        String df = arg.get(1);
        DecimalFormat decimalFormat = null;
        if (df != null) {
            try {
                decimalFormat = new DecimalFormat(df);
            }
            catch (IllegalArgumentException e) {
                return CommandExecutionResult.error("Error in pattern : " + df);
            }
        }
        if ((inc = arg.get(0)) == null) {
            sequenceDiagram.autonumberResume(decimalFormat);
        } else {
            sequenceDiagram.autonumberResume(Integer.parseInt(arg.get(0)), decimalFormat);
        }
        return CommandExecutionResult.ok();
    }
}

