/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.DotExpression;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DotCommon {
    private final DotData data;
    private final FileFormat fileFormat;
    private boolean underline;
    private final Rose rose = new Rose();

    DotCommon(FileFormat fileFormat, DotData dotData) {
        this.fileFormat = fileFormat;
        this.data = dotData;
    }

    protected final Stereotype getStereotype(IEntity iEntity) {
        if (!this.data.showPortion(EntityPortion.STEREOTYPE, iEntity)) {
            return null;
        }
        return iEntity.getStereotype();
    }

    protected final ColorMapper getColorMapper() {
        return this.data.getColorMapper();
    }

    protected final boolean isThereLabel(Stereotype stereotype) {
        return stereotype != null && stereotype.getLabel() != null;
    }

    protected final double getMagicFactorForImageDpi() {
        return 0.105;
    }

    protected final void appendLabelAndStereotype(IEntity iEntity, StringBuilder stringBuilder, boolean bl) {
        boolean bl2;
        String string;
        Stereotype stereotype = this.getStereotype(iEntity);
        String string2 = string = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        if (this.isThereLabel(stereotype)) {
            stringBuilder.append("<BR ALIGN=\"LEFT\"/>");
            stringBuilder.append(this.manageHtmlIB(stereotype.getLabel(), bl ? FontParam.CLASS_STEREOTYPE : FontParam.OBJECT_STEREOTYPE, string));
            stringBuilder.append("<BR/>");
        }
        String string3 = iEntity.getDisplay();
        boolean bl3 = bl2 = iEntity.getType() == EntityType.ABSTRACT_CLASS || iEntity.getType() == EntityType.INTERFACE;
        if (bl2) {
            string3 = "<i>" + string3;
        }
        stringBuilder.append(this.manageHtmlIB(string3, bl ? FontParam.CLASS : FontParam.OBJECT, string));
    }

    protected final String manageHtmlIB(String string, FontParam fontParam, String string2) {
        string = DotCommon.unicode(string);
        int n = this.data.getSkinParam().getFont(fontParam, string2).getSize();
        int n2 = this.data.getSkinParam().getFont(fontParam, string2).getStyle();
        String string3 = this.data.getSkinParam().getFont(fontParam, string2).getFamily(null);
        DotExpression dotExpression = new DotExpression(this.getColorMapper(), string, n, this.getFontHtmlColor(fontParam, string2), string3, n2, this.fileFormat);
        String string4 = dotExpression.getDotHtml();
        if (dotExpression.isUnderline()) {
            this.underline = true;
        }
        return string4;
    }

    protected final HtmlColor getFontHtmlColor(FontParam fontParam, String string) {
        return this.data.getSkinParam().getFontHtmlColor(fontParam, string);
    }

    static String unicode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|') {
                char c2 = c;
                stringBuilder.append("&#" + c2 + ";");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    protected final void addTdImageBugB1983(StringBuilder stringBuilder, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        double d = 1.0 / this.data.getDpiFactor();
        int n3 = (int)((double)n2 * d);
        int n4 = (int)((double)n * d);
        int n5 = (int)((double)n2 * this.getMagicFactorForImageDpi());
        int n6 = (int)((double)n * this.getMagicFactorForImageDpi());
        stringBuilder.append(this.getTdHeaderForDpi(n3, n4));
        stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        stringBuilder.append("<TR>");
        stringBuilder.append(this.getTdHeaderForDpi(n5, n6));
        stringBuilder.append("<IMG SCALE=\"TRUE\" SRC=\"" + string + "\"/>");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
        stringBuilder.append("</TD>");
    }

    protected final String getTdHeaderForDpi(double d, double d2) {
        return "<TD FIXEDSIZE=\"TRUE\" WIDTH=\"" + d + "\" HEIGHT=\"" + d2 + "\">";
    }

    public final boolean isUnderline() {
        return this.underline;
    }

    protected final DotData getData() {
        return this.data;
    }

    protected final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    protected final void setUnderline(boolean bl) {
        this.underline = bl;
    }

    protected final int getLongestMethods(IEntity iEntity) {
        int n = 0;
        for (Member member : iEntity.getMethodsToDisplay()) {
            int n2 = member.getDisplayWithVisibilityChar().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected final int getLongestField(IEntity iEntity) {
        int n = 0;
        for (Member member : iEntity.getFieldsToDisplay()) {
            int n2 = member.getDisplayWithVisibilityChar().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected final String getWitdh55() {
        if (this.getData().getDpi() == 96) {
            return "WIDTH=\"55\"";
        }
        return "WIDTH=\"55\"";
    }

    protected final int computeSpring(int n, int n2, int n3) {
        if (n2 <= n) {
            return 0;
        }
        int n4 = n2 - n;
        if (n4 > n3) {
            return n3;
        }
        return n4;
    }

    protected final int getLonguestHeader(IEntity iEntity) {
        int n;
        int n2 = iEntity.getDisplay().length();
        Stereotype stereotype = this.getStereotype(iEntity);
        if (this.isThereLabel(stereotype) && (n = stereotype.getLabel().length()) > n2) {
            n2 = n;
        }
        return n2;
    }

    protected final String getColorString(ColorParam colorParam, String string) {
        return "\"" + this.getAsHtml(this.rose.getHtmlColor(this.getData().getSkinParam(), colorParam, string)) + "\"";
    }

    protected final String getAsHtml(HtmlColor htmlColor) {
        return StringUtils.getAsHtml(this.getColorMapper().getMappedColor(htmlColor));
    }

    protected final int getLongestFieldOrAttribute(IEntity iEntity) {
        return Math.max(this.getLongestField(iEntity), this.getLongestMethods(iEntity));
    }

    protected final boolean hasStatic(Collection<Member> collection) {
        for (Member member : collection) {
            if (!member.isStatic()) continue;
            return true;
        }
        return false;
    }

    protected final String manageHtmlIBspecial(Member member, FontParam fontParam, boolean bl, String string, boolean bl2) {
        String string2 = "";
        if (bl) {
            string2 = "<FONT COLOR=" + string + ">_</FONT>";
        }
        if (member.isAbstract()) {
            return string2 + this.manageHtmlIB("<i>" + member.getDisplay(bl2), fontParam, null);
        }
        if (member.isStatic()) {
            return this.manageHtmlIB("<u>" + member.getDisplay(bl2), fontParam, null);
        }
        return string2 + this.manageHtmlIB(member.getDisplay(bl2), fontParam, null);
    }

    protected final String getBackColorAroundEntity(IEntity iEntity) {
        String string = this.getSpecificBackColor(iEntity);
        if (string == null) {
            string = this.getColorString(ColorParam.background, null);
        }
        return string;
    }

    private String getSpecificBackColor(IEntity iEntity) {
        Group group = iEntity.getParent();
        if (group == null) {
            return null;
        }
        if (group.getBackColor() == null) {
            return null;
        }
        return "\"" + this.getAsHtml(group.getBackColor()) + "\"";
    }

    protected final void appendImageAsTD(StringBuilder stringBuilder, String string) throws IOException {
        if (string.endsWith(".png")) {
            if (this.getData().getDpi() == 96) {
                BufferedImage bufferedImage = ImageIO.read(new File(string));
                int n = bufferedImage.getHeight();
                int n2 = bufferedImage.getWidth();
                stringBuilder.append("<TD FIXEDSIZE=\"TRUE\" WIDTH=\"" + n2 + "\" HEIGHT=\"" + n + "\"><IMG SRC=\"" + string + "\"/></TD>");
            } else {
                this.addTdImageBugB1983(stringBuilder, string);
            }
        } else if (string.endsWith(".eps")) {
            stringBuilder.append("<TD><IMG SRC=\"" + string + "\"/></TD>");
        }
    }
}

