/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Page {
    private final double headerHeight;
    private final double newpage1;
    private final double newpage2;
    private final double tailHeight;
    private final double signatureHeight;
    private final List<String> title;

    public String toString() {
        return "headerHeight=" + this.headerHeight + " newpage1=" + this.newpage1 + " newpage2=" + this.newpage2;
    }

    public Page(double d, double d2, double d3, double d4, double d5, List<String> list) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException();
        }
        if (d5 < 0.0) {
            throw new IllegalArgumentException();
        }
        if (d2 > d3) {
            throw new IllegalArgumentException();
        }
        this.headerHeight = d;
        this.newpage1 = d2;
        this.newpage2 = d3;
        this.tailHeight = d4;
        this.signatureHeight = d5;
        this.title = list;
    }

    public double getHeight() {
        return this.headerHeight + this.getBodyHeight() + this.tailHeight + this.signatureHeight;
    }

    public double getHeaderRelativePosition() {
        return 0.0;
    }

    public double getBodyRelativePosition() {
        return this.getHeaderRelativePosition() + this.headerHeight;
    }

    public double getBodyHeight() {
        return this.newpage2 - this.newpage1;
    }

    public double getTailRelativePosition() {
        return this.getBodyRelativePosition() + this.getBodyHeight();
    }

    public double getSignatureRelativePosition() {
        if (!this.displaySignature()) {
            return -1.0;
        }
        return this.getTailRelativePosition() + this.tailHeight;
    }

    public boolean displaySignature() {
        return this.signatureHeight > 0.0;
    }

    public double getNewpage1() {
        return this.newpage1;
    }

    public double getNewpage2() {
        return this.newpage2;
    }

    public double getHeaderHeight() {
        return this.headerHeight;
    }

    public final List<String> getTitle() {
        return this.title;
    }
}

