/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;

    public ComponentRoseParticipant(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, List<? extends CharSequence> list) {
        super(list, htmlColor3, uFont, HorizontalAlignement.CENTER, 7, 7, 7);
        this.back = htmlColor;
        this.foregroundColor = htmlColor2;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.getParam().setBackcolor(this.back);
        uGraphic.draw(0.0, 0.0, new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder)));
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(uGraphic, this.getMarginX1(), this.getMarginY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

