/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandNoteEntity
extends SingleLineCommand<AbstractEntityDiagram> {
    public CommandNoteEntity(AbstractEntityDiagram abstractEntityDiagram) {
        super(abstractEntityDiagram, "(?i)^note\\s+(right|left|top|bottom)\\s+of\\s+([\\p{L}0-9_.]+|\\((?!\\*\\))[^\\)]+\\)|\\[[^\\]*]+[^\\]]*\\]|\\(\\)\\s*[\\p{L}0-9_.]+|\\(\\)\\s*\"[^\"]+\"|:[^:]+:|\"[^\"]+\")\\s*(#\\w+)?\\s*:\\s*(.*)$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        Link link;
        String string = list.get(0);
        IEntity iEntity = ((AbstractEntityDiagram)this.getSystem()).getOrCreateClass(list.get(1));
        Entity entity = ((AbstractEntityDiagram)this.getSystem()).createEntity("GN" + UniqueSequence.getValue(), list.get(3), EntityType.NOTE);
        entity.setSpecificBackcolor(HtmlColor.getColorIfValid(list.get(2)));
        Position position = Position.valueOf(string.toUpperCase()).withRankdir(((AbstractEntityDiagram)this.getSystem()).getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, entity, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(entity, iEntity, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, entity, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(entity, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        ((AbstractEntityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

