/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageSplitter {
    private final double fullHeight;
    private final List<Double> positions;
    private final List<List<String>> titles;
    private final double headerHeight;
    private final double tailHeight;
    private final double signatureHeight;
    private final double newpageHeight;
    private final List<String> diagramTitle;

    PageSplitter(double d, double d2, Map<Newpage, Double> map, double d3, double d4, double d5, List<String> list) {
        this.fullHeight = d;
        this.diagramTitle = list;
        this.titles = new ArrayList<List<String>>();
        this.positions = new ArrayList<Double>();
        for (Map.Entry<Newpage, Double> entry : map.entrySet()) {
            this.titles.add(entry.getKey().getTitle());
            this.positions.add(entry.getValue());
        }
        this.headerHeight = d2;
        this.tailHeight = d3;
        this.signatureHeight = d4;
        this.newpageHeight = d5;
    }

    public List<Page> getPages() {
        if (this.positions.size() == 0) {
            return Arrays.asList(this.onePage());
        }
        ArrayList<Page> arrayList = new ArrayList<Page>();
        arrayList.add(this.firstPage());
        for (int i = 0; i < this.positions.size() - 1; ++i) {
            arrayList.add(this.createPage(i));
        }
        arrayList.add(this.lastPage());
        return arrayList;
    }

    private Page lastPage() {
        double d = this.positions.get(this.positions.size() - 1) - this.newpageHeight;
        double d2 = this.fullHeight - this.tailHeight - this.signatureHeight;
        List<String> list = this.titles.get(this.positions.size() - 1);
        return new Page(this.headerHeight, d, d2, this.tailHeight, this.signatureHeight, list);
    }

    private Page firstPage() {
        double d = this.headerHeight;
        double d2 = this.positions.get(0) + this.newpageHeight;
        return new Page(this.headerHeight, d, d2, this.tailHeight, 0.0, this.diagramTitle);
    }

    private Page onePage() {
        double d = this.headerHeight;
        double d2 = this.fullHeight - this.tailHeight - this.signatureHeight;
        return new Page(this.headerHeight, d, d2, this.tailHeight, this.signatureHeight, this.diagramTitle);
    }

    private Page createPage(int n) {
        double d = this.positions.get(n) - this.newpageHeight;
        double d2 = this.positions.get(n + 1) + this.newpageHeight;
        List<String> list = this.titles.get(n);
        return new Page(this.headerHeight, d, d2, this.tailHeight, 0.0, list);
    }
}

