/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.IEntityImageBlock;
import net.sourceforge.plantuml.posimo.Positionable;

public class MargedBlock {
    private final Block block;
    private final IEntityImageBlock imageBlock;
    private final double marginDecorator;
    private final Dimension2D imageDimension;
    private static int uid = 1;

    public MargedBlock(StringBounder stringBounder, IEntityImageBlock iEntityImageBlock, double d, Cluster cluster) {
        this.imageBlock = iEntityImageBlock;
        this.marginDecorator = d;
        this.imageDimension = iEntityImageBlock.getDimension(stringBounder);
        this.block = new Block(uid++, this.imageDimension.getWidth() + 2.0 * d, this.imageDimension.getHeight() + 2.0 * d, cluster);
    }

    public Block getBlock() {
        return this.block;
    }

    public double getMarginDecorator() {
        return this.marginDecorator;
    }

    public IEntityImageBlock getImageBlock() {
        return this.imageBlock;
    }

    public Positionable getImagePosition() {
        return new Positionable(){

            public Dimension2D getSize() {
                return MargedBlock.this.imageDimension;
            }

            public Point2D getPosition() {
                Point2D point2D = MargedBlock.this.block.getPosition();
                return new Point2D.Double(point2D.getX() + MargedBlock.this.marginDecorator, point2D.getY() + MargedBlock.this.marginDecorator);
            }
        };
    }
}

