/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.posimo.Positionable;

public class PositionableUtils {
    public static Rectangle2D convert(Positionable positionable) {
        Point2D point2D = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public static boolean contains(Positionable positionable, Point2D point2D) {
        Point2D point2D2 = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        if (point2D.getX() < point2D2.getX()) {
            return false;
        }
        if (point2D.getX() > point2D2.getX() + d) {
            return false;
        }
        if (point2D.getY() < point2D2.getY()) {
            return false;
        }
        return !(point2D.getY() > point2D2.getY() + d2);
    }

    public static Positionable addMargin(final Positionable positionable, final double d, final double d2) {
        return new Positionable(){

            public Point2D getPosition() {
                Point2D point2D = positionable.getPosition();
                return new Point2D.Double(point2D.getX() - d, point2D.getY() - d2);
            }

            public Dimension2D getSize() {
                return Dimension2DDouble.delta(positionable.getSize(), 2.0 * d, 2.0 * d2);
            }
        };
    }

    static Rectangle2D move(Rectangle2D rectangle2D, double d, double d2) {
        return new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
    }
}

