/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;

public class OptionFlags {
    public static final boolean PBBACK = false;
    private static final OptionFlags singleton = new OptionFlags();
    private boolean keepTmpFiles;
    private boolean verbose;
    private boolean metadata;
    private boolean word;
    private boolean systemExit;
    private boolean debugDot;
    private boolean forceGd;
    private boolean forceCairo;
    private String dotExecutable;
    private boolean gui;
    private boolean quiet;
    private boolean checkDotError;
    private boolean printFonts;
    private boolean useSuggestEngine;
    private boolean failOnError;
    private File logData;
    private final AtomicBoolean logDataInitized = new AtomicBoolean(false);

    void reset() {
        this.reset(false);
    }

    private void reset(boolean bl) {
        this.keepTmpFiles = false;
        this.verbose = false;
        this.metadata = false;
        this.word = false;
        this.systemExit = bl;
        this.debugDot = false;
        this.forceGd = false;
        this.forceCairo = false;
        this.dotExecutable = null;
        this.gui = false;
        this.quiet = false;
        this.checkDotError = false;
        this.printFonts = false;
        this.useSuggestEngine = true;
        this.failOnError = false;
    }

    public boolean useJavaInsteadOfDot() {
        return false;
    }

    private OptionFlags() {
        this.reset(true);
    }

    public static OptionFlags getInstance() {
        return singleton;
    }

    public final synchronized boolean isKeepTmpFiles() {
        return this.keepTmpFiles;
    }

    public final synchronized void setKeepTmpFiles(boolean bl) {
        this.keepTmpFiles = bl;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean isMetadata() {
        return this.metadata;
    }

    public final void setMetadata(boolean bl) {
        this.metadata = bl;
    }

    public final boolean isWord() {
        return this.word;
    }

    public final void setWord(boolean bl) {
        this.word = bl;
    }

    public final boolean isSystemExit() {
        return this.systemExit;
    }

    public final void setSystemExit(boolean bl) {
        this.systemExit = bl;
    }

    public final boolean isDebugDot() {
        return this.debugDot;
    }

    public final void setDebugDot(boolean bl) {
        this.debugDot = bl;
    }

    public final String getDotExecutable() {
        return this.dotExecutable;
    }

    public final void setDotExecutable(String string) {
        this.dotExecutable = string;
    }

    public final boolean isGui() {
        return this.gui;
    }

    public final void setGui(boolean bl) {
        this.gui = bl;
    }

    public final boolean isForceGd() {
        return this.forceGd;
    }

    public final void setForceGd(boolean bl) {
        this.forceGd = bl;
    }

    public final boolean isForceCairo() {
        return this.forceCairo;
    }

    public final void setForceCairo(boolean bl) {
        this.forceCairo = bl;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public final boolean isCheckDotError() {
        return this.checkDotError;
    }

    public final void setCheckDotError(boolean bl) {
        this.checkDotError = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logData(File file, PSystem pSystem) {
        if (!(pSystem instanceof PSystemError)) {
            return;
        }
        AtomicBoolean atomicBoolean = this.logDataInitized;
        synchronized (atomicBoolean) {
            Object object;
            if (this.logData == null && !this.logDataInitized.get()) {
                object = GraphvizUtils.getenvLogData();
                if (object != null) {
                    this.setLogData(new File((String)object));
                }
                this.logDataInitized.set(true);
            }
            if (this.logData == null) {
                return;
            }
            object = (PSystemError)pSystem;
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new FileOutputStream(this.logData, true));
                printStream.println("Start of " + file.getName());
                printStream.println(((PSystemError)object).getDescription());
                for (String string : ((AbstractPSystem)object).getTitle()) {
                    printStream.println(string);
                }
                ((PSystemError)object).print(printStream);
                for (String string : ((PSystemError)object).getSuggest()) {
                    printStream.println(string);
                }
                printStream.println("End of " + file.getName());
                printStream.println();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.error("Cannot open " + this.logData);
                fileNotFoundException.printStackTrace();
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogData(File file) {
        this.logData = file;
        file.delete();
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error("Cannot open " + file);
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public final boolean isPrintFonts() {
        return this.printFonts;
    }

    public final void setPrintFonts(boolean bl) {
        this.printFonts = bl;
    }

    public final boolean isUseSuggestEngine() {
        return this.useSuggestEngine;
    }

    public final void setUseSuggestEngine(boolean bl) {
        this.useSuggestEngine = bl;
    }

    public final boolean isFailOnError() {
        return this.failOnError;
    }

    public final void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }
}

