/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTextArrow
implements Component {
    private final ComponentType type;
    private final List<? extends CharSequence> stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextArrow(ComponentType componentType, List<? extends CharSequence> list, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = list;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic uGraphic, Dimension2D dimension2D, Context2D context2D) {
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        int n3 = StringUtils.getWidth(this.stringsToDisplay);
        int n4 = n2 - 2;
        umlCharArea.drawHLine(this.fileFormat == FileFormat.UTXT ? (char)'\u2500' : '-', n4, 1, n);
        if (this.type.getArrowConfiguration().isDotted()) {
            for (int i = 1; i < n; i += 2) {
                umlCharArea.drawChar(' ', i, n4);
            }
        }
        if (this.type.getArrowConfiguration().isLeftToRightNormal()) {
            umlCharArea.drawChar('>', n - 1, n4);
        } else if (this.type.getArrowConfiguration().isRightToLeftReverse()) {
            umlCharArea.drawChar('<', 1, n4);
        } else {
            throw new UnsupportedOperationException();
        }
        umlCharArea.drawStringsLR(this.stringsToDisplay, (n - n3) / 2, 0);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

