/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DotExpression {
    private final StringBuilder sb = new StringBuilder();
    private final UFont normalFont;
    private FontConfiguration fontConfiguration;
    private final boolean underline;
    private final String fontFamily;
    private final FileFormat fileFormat;
    private final ColorMapper colorMapper;
    private boolean hasImg;

    DotExpression(ColorMapper colorMapper, String string, int n, HtmlColor htmlColor, String string2, int n2, FileFormat fileFormat) {
        if (string.contains("\n")) {
            throw new IllegalArgumentException(string);
        }
        this.colorMapper = colorMapper;
        this.fontFamily = string2;
        this.normalFont = new UFont("SansSerif", 0, n);
        this.fontConfiguration = new FontConfiguration(this.normalFont, htmlColor);
        this.fileFormat = fileFormat;
        if ((n2 & 2) != 0) {
            string = "<i>" + string;
        }
        if ((n2 & 1) != 0) {
            string = "<b>" + string;
        }
        string = string.replaceAll(" \\<[uU]\\>", "<u>");
        this.underline = (string = string.replaceAll("\\</[uU]\\> ", "</u>")).contains("<u>") || string.contains("<U>");
        Splitter splitter = new Splitter(string);
        List<HtmlCommand> list = splitter.getHtmlCommands(false);
        for (HtmlCommand object : list) {
            if (!(object instanceof Img)) continue;
            this.hasImg = true;
        }
        if (this.hasImg) {
            list = splitter.getHtmlCommands(true);
            this.sb.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\">");
            for (Collection collection : DotExpression.split(list)) {
                this.sb.append("<TR><TD><TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\"><TR>");
                this.manageCommands(collection);
                this.sb.append("</TR></TABLE></TD></TR>");
            }
            this.sb.append("</TABLE>");
        } else {
            this.manageCommands(list);
        }
    }

    private static List<Collection<HtmlCommand>> split(Collection<HtmlCommand> collection) {
        ArrayList<Collection<HtmlCommand>> arrayList = new ArrayList<Collection<HtmlCommand>>();
        ArrayList<HtmlCommand> arrayList2 = null;
        for (HtmlCommand htmlCommand : collection) {
            if (htmlCommand instanceof Text && ((Text)htmlCommand).isNewline()) {
                arrayList2 = null;
                continue;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<HtmlCommand>();
                arrayList.add(arrayList2);
            }
            arrayList2.add(htmlCommand);
        }
        return arrayList;
    }

    private void manageCommands(Collection<HtmlCommand> collection) {
        for (HtmlCommand htmlCommand : collection) {
            if (htmlCommand instanceof Text) {
                this.manage((Text)htmlCommand);
                continue;
            }
            if (htmlCommand instanceof FontChange) {
                this.manage((FontChange)htmlCommand);
                continue;
            }
            if (htmlCommand instanceof Img) {
                this.manageImage((Img)htmlCommand);
                continue;
            }
            Log.error("Cannot manage " + htmlCommand);
        }
    }

    private void manageImage(Img img) {
        try {
            File file = FileSystem.getInstance().getFile(img.getFilePath());
            if (!file.exists()) {
                throw new IOException();
            }
            this.sb.append("<TD><IMG SRC=\"" + file.getAbsolutePath() + "\"/></TD>");
        }
        catch (IOException iOException) {
            this.sb.append("<TD>File Not Found</TD>");
        }
    }

    private void manage(FontChange fontChange) {
        this.fontConfiguration = fontChange.apply(this.fontConfiguration);
    }

    private void manage(Text text) {
        if (this.hasImg) {
            this.sb.append("<TD>");
        }
        this.underline(false);
        this.sb.append(this.getFontTag());
        String string = text.getText();
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        if (!this.hasImg) {
            string = string.replace("\\n", "<BR/>");
        }
        this.sb.append(string);
        this.sb.append("</FONT>");
        this.underline(true);
        if (this.hasImg) {
            this.sb.append("</TD>");
            if (string.contains("\\n")) {
                throw new IllegalStateException();
            }
        }
    }

    private String getFontTag() {
        int n = this.fontConfiguration.getFont().getSize();
        StringBuilder stringBuilder = new StringBuilder("<FONT POINT-SIZE=\"");
        stringBuilder.append(n);
        stringBuilder.append("\" ");
        this.appendFontWithFamily(stringBuilder);
        HtmlColor htmlColor = this.fontConfiguration.getColor();
        stringBuilder.append(" COLOR=\"").append(StringUtils.getAsHtml(this.colorMapper.getMappedColor(htmlColor))).append("\"");
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    private void appendFontWithFamily(StringBuilder stringBuilder) {
        String string = null;
        if (this.fontConfiguration.containsStyle(FontStyle.ITALIC)) {
            string = "italic";
        } else if (this.fontConfiguration.containsStyle(FontStyle.BOLD)) {
            string = "bold";
        }
        DotExpression.appendFace(stringBuilder, this.fontFamily, string);
    }

    private static void appendFace(StringBuilder stringBuilder, String string, String string2) {
        if (string == null && string2 == null) {
            return;
        }
        stringBuilder.append("FACE=\"");
        if (string != null && string2 != null) {
            stringBuilder.append(string + " " + string2);
        } else if (string != null) {
            assert (string2 == null);
            stringBuilder.append(string);
        } else if (string2 != null) {
            assert (string == null);
            stringBuilder.append(string2);
        } else assert (false);
        stringBuilder.append("\"");
    }

    private void underline(boolean bl) {
        if (this.fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            String string = "_";
            if (bl && this.fileFormat == FileFormat.EPS) {
                string = "_!";
            }
            this.sb.append("<FONT COLOR=\"#FEFECF\">" + string + "</FONT>");
        }
    }

    public String getDotHtml() {
        return this.sb.toString();
    }

    boolean isUnderline() {
        return this.underline;
    }
}

