/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseArrow
extends AbstractComponentRoseArrow {
    private final HorizontalAlignement messagePosition;

    public ComponentRoseArrow(HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, List<? extends CharSequence> list, ArrowConfiguration arrowConfiguration, HorizontalAlignement horizontalAlignement) {
        super(htmlColor, htmlColor2, uFont, list, arrowConfiguration);
        this.messagePosition = horizontalAlignement;
    }

    @Override
    public void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        double d;
        UPolygon uPolygon;
        int n;
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n2 = (int)this.getTextHeight(stringBounder);
        uGraphic.getParam().setColor(this.getForegroundColor());
        int n3 = (int)dimension2D.getWidth();
        if (this.getArrowConfiguration().isDotted()) {
            this.stroke(uGraphic, 2.0, 2.0);
        }
        uGraphic.draw(0.0, n2, new ULine(n3, 0.0));
        if (this.getArrowConfiguration().isDotted()) {
            uGraphic.getParam().setStroke(new UStroke());
        }
        if ((n = this.getDirection()) == 1) {
            if (this.getArrowConfiguration().isASync()) {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.draw(n3, n2, new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.draw(n3, n2, new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()));
                }
            } else {
                uGraphic.getParam().setBackcolor(this.getForegroundColor());
                uPolygon = this.getPolygonNormal(n2, n3);
                uGraphic.draw(0.0, 0.0, uPolygon);
                uGraphic.getParam().setBackcolor(null);
            }
        } else if (this.getArrowConfiguration().isASync()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                uGraphic.draw(0.0, n2, new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                uGraphic.draw(0.0, n2, new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else {
            uGraphic.getParam().setBackcolor(this.getForegroundColor());
            uPolygon = this.getPolygonReverse(n2);
            uGraphic.draw(0.0, 0.0, uPolygon);
            uGraphic.getParam().setBackcolor(null);
        }
        if (this.messagePosition == HorizontalAlignement.CENTER) {
            double d2 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = (dimension2D.getWidth() - d2) / 2.0;
        } else if (this.messagePosition == HorizontalAlignement.RIGHT) {
            double d3 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = dimension2D.getWidth() - d3 - (double)this.getMarginX2();
        } else {
            d = this.getMarginX1();
        }
        this.getTextBlock().drawU(uGraphic, d, 0.0);
    }

    private UPolygon getPolygonNormal(int n, int n2) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n);
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n + this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
        return uPolygon;
    }

    private UPolygon getPolygonReverse(int n) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n);
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
        return uPolygon;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getDirection() == 1) {
            return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getDirection() == 1) {
            return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    protected final int getDirection() {
        if (this.getArrowConfiguration().isLeftToRightNormal()) {
            return 1;
        }
        if (this.getArrowConfiguration().isRightToLeftReverse()) {
            return -1;
        }
        throw new IllegalStateException();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

