/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

public class UGradient {
    private final HtmlColor color1;
    private final HtmlColor color2;

    public UGradient(HtmlColor htmlColor, HtmlColor htmlColor2) {
        if (htmlColor == null || htmlColor2 == null) {
            throw new IllegalArgumentException();
        }
        this.color1 = htmlColor;
        this.color2 = htmlColor2;
    }

    public final HtmlColor getColor1() {
        return this.color1;
    }

    public final HtmlColor getColor2() {
        return this.color2;
    }

    public final Color getColor(ColorMapper colorMapper, double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("c=" + d);
        }
        Color color = colorMapper.getMappedColor(this.color1);
        Color color2 = colorMapper.getMappedColor(this.color2);
        int n = color2.getRed() - color.getRed();
        int n2 = color2.getGreen() - color.getGreen();
        int n3 = color2.getBlue() - color.getBlue();
        int n4 = color.getRed() + (int)(d * (double)n);
        int n5 = color.getGreen() + (int)(d * (double)n2);
        int n6 = color.getBlue() + (int)(d * (double)n3);
        return new Color(n4, n5, n6);
    }
}

