/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_engine.impl.ResultSpecification_impl;
import org.apache.uima.analysis_engine.impl.RsFeat;
import org.apache.uima.analysis_engine.impl.RsFeats;
import org.apache.uima.analysis_engine.impl.RsLangs;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RsType {
    public static final List<Feature> EMPTY_FEATURE_LIST = new ArrayList<Feature>(0);
    final String typeName;
    boolean isAllFeatures = false;
    boolean isSpecified = false;
    RsLangs languagesAllFeat = null;
    RsLangs languagesNotAllFeat = null;
    RsFeats features = null;

    RsType(String name) {
        this.typeName = name;
    }

    RsType(RsType original) {
        this.typeName = original.typeName;
        this.isAllFeatures = original.isAllFeatures;
        this.isSpecified = original.isSpecified;
        this.languagesAllFeat = RsLangs.createOrNull(original.languagesAllFeat);
        this.languagesNotAllFeat = RsLangs.createOrNull(original.languagesNotAllFeat);
        this.features = original.features == null ? null : new RsFeats(original.features);
    }

    boolean subsumesLanguageInFeat(String shortFeatName, String lang) {
        if (this.isAllFeatures && RsLangs.subsumes(this.languagesAllFeat, lang)) {
            return true;
        }
        RsFeat f = this.getFeat(shortFeatName);
        if (null == f) {
            return false;
        }
        return RsLangs.subsumes(f.languages, lang);
    }

    RsFeat getFeat(String shortFeatName) {
        if (null == this.features) {
            return null;
        }
        return this.features.get(shortFeatName);
    }

    List<Feature> getAllAppropriateFeatures(TypeSystem ts) {
        if (null == ts) {
            return EMPTY_FEATURE_LIST;
        }
        Type t = ts.getType(this.typeName);
        return null == t ? EMPTY_FEATURE_LIST : t.getFeatures();
    }

    boolean hasAllFeaturesExplicitly(TypeSystem ts) {
        int fz;
        List<Feature> all = this.getAllAppropriateFeatures(ts);
        if (all.size() == 0) {
            return this.features == null || this.features.features == null || this.features.features.size() == 0 || ts == null;
        }
        int n = fz = this.features == null || this.features.features == null ? 0 : this.features.features.size();
        if (fz == all.size()) {
            for (Feature f : all) {
                if (this.features.contains(this.typeName, f.getShortName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean allFeaturesHaveSameLangs() {
        if (this.features == null) {
            return false;
        }
        int fz = this.features.size();
        if (fz == 0) {
            return false;
        }
        if (fz == 1) {
            return true;
        }
        List<RsFeat> rsf = this.features.features;
        RsLangs l = rsf.get((int)0).languages;
        for (int i = 1; i < fz; ++i) {
            RsLangs fl = rsf.get((int)i).languages;
            if (ResultSpecification_impl.equalsOrBothNull(l, fl)) continue;
            return false;
        }
        return true;
    }
}

