/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoLatitudeZone
extends GeoBBoxBase {
    public final double topLat;
    public final double bottomLat;
    public final double cosTopLat;
    public final double cosBottomLat;
    public final SidedPlane topPlane;
    public final SidedPlane bottomPlane;
    public final GeoPoint interiorPoint;
    public static final GeoPoint[] planePoints = new GeoPoint[0];
    public final GeoPoint topBoundaryPoint;
    public final GeoPoint bottomBoundaryPoint;
    public final GeoPoint[] edgePoints;

    public GeoLatitudeZone(double topLat, double bottomLat) {
        this.topLat = topLat;
        this.bottomLat = bottomLat;
        double sinTopLat = Math.sin(topLat);
        double sinBottomLat = Math.sin(bottomLat);
        this.cosTopLat = Math.cos(topLat);
        this.cosBottomLat = Math.cos(bottomLat);
        Vector topPoint = new Vector(0.0, 0.0, sinTopLat);
        Vector bottomPoint = new Vector(0.0, 0.0, sinBottomLat);
        double middleLat = (topLat + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.interiorPoint = new GeoPoint(Math.sqrt(1.0 - sinMiddleLat * sinMiddleLat), 0.0, sinMiddleLat);
        this.topBoundaryPoint = new GeoPoint(Math.sqrt(1.0 - sinTopLat * sinTopLat), 0.0, sinTopLat);
        this.bottomBoundaryPoint = new GeoPoint(Math.sqrt(1.0 - sinBottomLat * sinBottomLat), 0.0, sinBottomLat);
        this.topPlane = new SidedPlane((Vector)this.interiorPoint, sinTopLat);
        this.bottomPlane = new SidedPlane((Vector)this.interiorPoint, sinBottomLat);
        this.edgePoints = new GeoPoint[]{this.topBoundaryPoint, this.bottomBoundaryPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = this.bottomLat - angle;
        return GeoBBoxFactory.makeGeoBBox(newTopLat, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.topPlane.isWithin(point) && this.bottomPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z) && this.bottomPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        if (this.topLat > 0.0 && this.bottomLat < 0.0) {
            return Math.PI;
        }
        double maxCosLat = this.cosTopLat;
        if (maxCosLat < this.cosBottomLat) {
            maxCosLat = this.cosBottomLat;
        }
        return maxCosLat * Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.topPlane, notablePoints, planePoints, bounds, this.bottomPlane) || p.intersects(this.bottomPlane, notablePoints, planePoints, bounds, this.topPlane);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noLongitudeBound().addLatitudeZone(this.topLat).addLatitudeZone(this.bottomLat);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        boolean insideShape;
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean topBoundaryInsideShape = path.isWithin(this.topBoundaryPoint);
        boolean bottomBoundaryInsideShape = path.isWithin(this.bottomBoundaryPoint);
        if (topBoundaryInsideShape && !bottomBoundaryInsideShape || !topBoundaryInsideShape && bottomBoundaryInsideShape) {
            return 2;
        }
        boolean bl = insideShape = topBoundaryInsideShape && bottomBoundaryInsideShape;
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.topPlane, planePoints, this.bottomPlane) || path.intersects(this.bottomPlane, planePoints, this.topPlane)) {
            return 2;
        }
        if (insideShape) {
            return 0;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoLatitudeZone)) {
            return false;
        }
        GeoLatitudeZone other = (GeoLatitudeZone)o;
        return other.topPlane.equals(this.topPlane) && other.bottomPlane.equals(this.bottomPlane);
    }

    public int hashCode() {
        int result = this.topPlane.hashCode();
        result = 31 * result + this.bottomPlane.hashCode();
        return result;
    }

    public String toString() {
        return "GeoLatitudeZone: {toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + ")}";
    }
}

