/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import org.apache.solr.analytics.plugin.AnalyticsStatisticsCollector;
import org.apache.solr.analytics.request.AnalyticsStats;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;

public class AnalyticsComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "analytics";
    private final AnalyticsStatisticsCollector analyticsCollector = new AnalyticsStatisticsCollector();

    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool("olap", false)) {
            rb.setNeedDocSet(true);
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool("olap", false)) {
            SolrParams params = rb.req.getParams();
            AnalyticsStats s = new AnalyticsStats(rb.req, rb.getResults().docSet, params, this.analyticsCollector);
            rb.rsp.add("stats", s.execute());
        }
    }

    public String getName() {
        return COMPONENT_NAME;
    }

    public String getDescription() {
        return "Perform analytics";
    }

    public String getVersion() {
        return ((Object)((Object)this)).getClass().getPackage().getSpecificationVersion();
    }

    public NamedList getStatistics() {
        return this.analyticsCollector.getStatistics();
    }
}

