/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SparseRowMatrix
extends AbstractMatrix {
    private Vector[] rowVectors;
    private final boolean randomAccessRows;

    public SparseRowMatrix(int rows, int columns, Vector[] rowVectors) {
        this(rows, columns, rowVectors, false, rowVectors instanceof RandomAccessSparseVector[]);
    }

    public SparseRowMatrix(int rows, int columns, boolean randomAccess) {
        this(rows, columns, randomAccess ? new RandomAccessSparseVector[rows] : new SequentialAccessSparseVector[rows], true, randomAccess);
    }

    public SparseRowMatrix(int rows, int columns, Vector[] vectors, boolean shallowCopy, boolean randomAccess) {
        super(rows, columns);
        this.randomAccessRows = randomAccess;
        this.rowVectors = (Vector[])vectors.clone();
        for (int row = 0; row < rows; ++row) {
            if (vectors[row] == null) {
                vectors[row] = randomAccess ? new RandomAccessSparseVector(this.numCols(), 10) : new SequentialAccessSparseVector(this.numCols(), 10);
            }
            this.rowVectors[row] = shallowCopy ? vectors[row] : vectors[row].clone();
        }
    }

    public SparseRowMatrix(int rows, int columns) {
        this(rows, columns, true);
    }

    @Override
    public Matrix clone() {
        SparseRowMatrix clone = (SparseRowMatrix)super.clone();
        clone.rowVectors = new Vector[this.rowVectors.length];
        for (int i = 0; i < this.rowVectors.length; ++i) {
            clone.rowVectors[i] = this.rowVectors[i].clone();
        }
        return clone;
    }

    @Override
    public double getQuick(int row, int column) {
        return this.rowVectors[row] == null ? 0.0 : this.rowVectors[row].getQuick(column);
    }

    @Override
    public Matrix like() {
        return new SparseRowMatrix(this.rowSize(), this.columnSize(), this.randomAccessRows);
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseRowMatrix(rows, columns, this.randomAccessRows);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.rowVectors[row].setQuick(column, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[0] = this.rowVectors.length;
        for (int row = 0; row < this.rowSize(); ++row) {
            result[1] = Math.max(result[1], this.rowVectors[row].getNumNondefaultElements());
        }
        return result;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], this.rowVectors.length);
        }
        if (offset[0] + size[0] > this.rowVectors.length) {
            throw new IndexException(offset[0] + size[0], this.rowVectors.length);
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], this.rowVectors[0].size());
        }
        if (offset[1] + size[1] > this.rowVectors[0].size()) {
            throw new IndexException(offset[1] + size[1], this.rowVectors[0].size());
        }
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.rowSize() != other.size()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        for (int row = 0; row < this.rowSize(); ++row) {
            this.rowVectors[row].setQuick(column, other.getQuick(row));
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new CardinalityException(this.columnSize(), other.size());
        }
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        this.rowVectors[row].assign(other);
        return this;
    }

    @Override
    public Vector viewRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        return this.rowVectors[row];
    }
}

