/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;

public class EigenSolverWrapper {
    private final double[] eigenvalues;
    private final double[][] uHat;

    public EigenSolverWrapper(double[][] bbt) {
        int dim = bbt.length;
        EigenDecompositionImpl evd2 = new EigenDecompositionImpl((RealMatrix)new Array2DRowRealMatrix(bbt), 0.0);
        this.eigenvalues = evd2.getRealEigenvalues();
        RealMatrix uHatrm = evd2.getV();
        this.uHat = new double[dim][];
        for (int i = 0; i < dim; ++i) {
            this.uHat[i] = uHatrm.getRow(i);
        }
    }

    public double[][] getUHat() {
        return this.uHat;
    }

    public double[] getEigenValues() {
        return this.eigenvalues;
    }
}

