/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Descriptor(tags={3})
public class ESDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(ESDescriptor.class.getName());
    int esId;
    int streamDependenceFlag;
    int URLFlag;
    int oCRstreamFlag;
    int streamPriority;
    int URLLength = 0;
    String URLString;
    int remoteODFlag;
    int dependsOnEsId;
    int oCREsId;
    DecoderConfigDescriptor decoderConfigDescriptor;
    SLConfigDescriptor slConfigDescriptor;
    List<BaseDescriptor> otherDescriptors = new ArrayList<BaseDescriptor>();

    @Override
    public void parseDetail(ByteBuffer bb) throws IOException {
        int size;
        long read;
        BaseDescriptor descriptor;
        this.esId = IsoTypeReader.readUInt16(bb);
        int data = IsoTypeReader.readUInt8(bb);
        this.streamDependenceFlag = data >>> 7;
        this.URLFlag = data >>> 6 & 1;
        this.oCRstreamFlag = data >>> 5 & 1;
        this.streamPriority = data & 0x1F;
        if (this.streamDependenceFlag == 1) {
            this.dependsOnEsId = IsoTypeReader.readUInt16(bb);
        }
        if (this.URLFlag == 1) {
            this.URLLength = IsoTypeReader.readUInt8(bb);
            this.URLString = IsoTypeReader.readString(bb, this.URLLength);
        }
        if (this.oCRstreamFlag == 1) {
            this.oCREsId = IsoTypeReader.readUInt16(bb);
        }
        int baseSize = 1 + this.getSizeBytes() + 2 + 1 + (this.streamDependenceFlag == 1 ? 2 : 0) + (this.URLFlag == 1 ? 1 + this.URLLength : 0) + (this.oCRstreamFlag == 1 ? 2 : 0);
        int begin = bb.position();
        if (this.getSize() > baseSize + 2) {
            descriptor = ObjectDescriptorFactory.createFrom(-1, bb);
            read = bb.position() - begin;
            log.finer(descriptor + " - ESDescriptor1 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                bb.position(begin + size);
                baseSize += size;
            } else {
                baseSize = (int)((long)baseSize + read);
            }
            if (descriptor instanceof DecoderConfigDescriptor) {
                this.decoderConfigDescriptor = (DecoderConfigDescriptor)descriptor;
            }
        }
        begin = bb.position();
        if (this.getSize() > baseSize + 2) {
            descriptor = ObjectDescriptorFactory.createFrom(-1, bb);
            read = bb.position() - begin;
            log.finer(descriptor + " - ESDescriptor2 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                bb.position(begin + size);
                baseSize += size;
            } else {
                baseSize = (int)((long)baseSize + read);
            }
            if (descriptor instanceof SLConfigDescriptor) {
                this.slConfigDescriptor = (SLConfigDescriptor)descriptor;
            }
        } else {
            log.warning("SLConfigDescriptor is missing!");
        }
        while (this.getSize() - baseSize > 2) {
            begin = bb.position();
            descriptor = ObjectDescriptorFactory.createFrom(-1, bb);
            read = bb.position() - begin;
            log.finer(descriptor + " - ESDescriptor3 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                bb.position(begin + size);
                baseSize += size;
            } else {
                baseSize = (int)((long)baseSize + read);
            }
            this.otherDescriptors.add(descriptor);
        }
    }

    public int serializedSize() {
        int out = 5;
        if (this.streamDependenceFlag > 0) {
            out += 2;
        }
        if (this.URLFlag > 0) {
            out += 1 + this.URLLength;
        }
        if (this.oCRstreamFlag > 0) {
            out += 2;
        }
        out += this.decoderConfigDescriptor.serializedSize();
        return out += this.slConfigDescriptor.serializedSize();
    }

    public ByteBuffer serialize() {
        ByteBuffer out = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8(out, 3);
        IsoTypeWriter.writeUInt8(out, this.serializedSize() - 2);
        IsoTypeWriter.writeUInt16(out, this.esId);
        int flags = this.streamDependenceFlag << 7 | this.URLFlag << 6 | this.oCRstreamFlag << 5 | this.streamPriority & 0x1F;
        IsoTypeWriter.writeUInt8(out, flags);
        if (this.streamDependenceFlag > 0) {
            IsoTypeWriter.writeUInt16(out, this.dependsOnEsId);
        }
        if (this.URLFlag > 0) {
            IsoTypeWriter.writeUInt8(out, this.URLLength);
            IsoTypeWriter.writeUtf8String(out, this.URLString);
        }
        if (this.oCRstreamFlag > 0) {
            IsoTypeWriter.writeUInt16(out, this.oCREsId);
        }
        ByteBuffer dec = this.decoderConfigDescriptor.serialize();
        ByteBuffer sl = this.slConfigDescriptor.serialize();
        out.put(dec.array());
        out.put(sl.array());
        return out;
    }

    public DecoderConfigDescriptor getDecoderConfigDescriptor() {
        return this.decoderConfigDescriptor;
    }

    public SLConfigDescriptor getSlConfigDescriptor() {
        return this.slConfigDescriptor;
    }

    public void setDecoderConfigDescriptor(DecoderConfigDescriptor decoderConfigDescriptor) {
        this.decoderConfigDescriptor = decoderConfigDescriptor;
    }

    public void setSlConfigDescriptor(SLConfigDescriptor slConfigDescriptor) {
        this.slConfigDescriptor = slConfigDescriptor;
    }

    public List<BaseDescriptor> getOtherDescriptors() {
        return this.otherDescriptors;
    }

    public int getoCREsId() {
        return this.oCREsId;
    }

    public void setoCREsId(int oCREsId) {
        this.oCREsId = oCREsId;
    }

    public int getEsId() {
        return this.esId;
    }

    public void setEsId(int esId) {
        this.esId = esId;
    }

    public int getStreamDependenceFlag() {
        return this.streamDependenceFlag;
    }

    public void setStreamDependenceFlag(int streamDependenceFlag) {
        this.streamDependenceFlag = streamDependenceFlag;
    }

    public int getURLFlag() {
        return this.URLFlag;
    }

    public void setURLFlag(int URLFlag) {
        this.URLFlag = URLFlag;
    }

    public int getoCRstreamFlag() {
        return this.oCRstreamFlag;
    }

    public void setoCRstreamFlag(int oCRstreamFlag) {
        this.oCRstreamFlag = oCRstreamFlag;
    }

    public int getStreamPriority() {
        return this.streamPriority;
    }

    public void setStreamPriority(int streamPriority) {
        this.streamPriority = streamPriority;
    }

    public int getURLLength() {
        return this.URLLength;
    }

    public void setURLLength(int URLLength) {
        this.URLLength = URLLength;
    }

    public String getURLString() {
        return this.URLString;
    }

    public void setURLString(String URLString) {
        this.URLString = URLString;
    }

    public int getRemoteODFlag() {
        return this.remoteODFlag;
    }

    public void setRemoteODFlag(int remoteODFlag) {
        this.remoteODFlag = remoteODFlag;
    }

    public int getDependsOnEsId() {
        return this.dependsOnEsId;
    }

    public void setDependsOnEsId(int dependsOnEsId) {
        this.dependsOnEsId = dependsOnEsId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ESDescriptor");
        sb.append("{esId=").append(this.esId);
        sb.append(", streamDependenceFlag=").append(this.streamDependenceFlag);
        sb.append(", URLFlag=").append(this.URLFlag);
        sb.append(", oCRstreamFlag=").append(this.oCRstreamFlag);
        sb.append(", streamPriority=").append(this.streamPriority);
        sb.append(", URLLength=").append(this.URLLength);
        sb.append(", URLString='").append(this.URLString).append('\'');
        sb.append(", remoteODFlag=").append(this.remoteODFlag);
        sb.append(", dependsOnEsId=").append(this.dependsOnEsId);
        sb.append(", oCREsId=").append(this.oCREsId);
        sb.append(", decoderConfigDescriptor=").append(this.decoderConfigDescriptor);
        sb.append(", slConfigDescriptor=").append(this.slConfigDescriptor);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ESDescriptor that = (ESDescriptor)o;
        if (this.URLFlag != that.URLFlag) {
            return false;
        }
        if (this.URLLength != that.URLLength) {
            return false;
        }
        if (this.dependsOnEsId != that.dependsOnEsId) {
            return false;
        }
        if (this.esId != that.esId) {
            return false;
        }
        if (this.oCREsId != that.oCREsId) {
            return false;
        }
        if (this.oCRstreamFlag != that.oCRstreamFlag) {
            return false;
        }
        if (this.remoteODFlag != that.remoteODFlag) {
            return false;
        }
        if (this.streamDependenceFlag != that.streamDependenceFlag) {
            return false;
        }
        if (this.streamPriority != that.streamPriority) {
            return false;
        }
        if (this.URLString != null ? !this.URLString.equals(that.URLString) : that.URLString != null) {
            return false;
        }
        if (this.decoderConfigDescriptor != null ? !this.decoderConfigDescriptor.equals(that.decoderConfigDescriptor) : that.decoderConfigDescriptor != null) {
            return false;
        }
        if (this.otherDescriptors != null ? !this.otherDescriptors.equals(that.otherDescriptors) : that.otherDescriptors != null) {
            return false;
        }
        return !(this.slConfigDescriptor != null ? !this.slConfigDescriptor.equals(that.slConfigDescriptor) : that.slConfigDescriptor != null);
    }

    public int hashCode() {
        int result = this.esId;
        result = 31 * result + this.streamDependenceFlag;
        result = 31 * result + this.URLFlag;
        result = 31 * result + this.oCRstreamFlag;
        result = 31 * result + this.streamPriority;
        result = 31 * result + this.URLLength;
        result = 31 * result + (this.URLString != null ? this.URLString.hashCode() : 0);
        result = 31 * result + this.remoteODFlag;
        result = 31 * result + this.dependsOnEsId;
        result = 31 * result + this.oCREsId;
        result = 31 * result + (this.decoderConfigDescriptor != null ? this.decoderConfigDescriptor.hashCode() : 0);
        result = 31 * result + (this.slConfigDescriptor != null ? this.slConfigDescriptor.hashCode() : 0);
        result = 31 * result + (this.otherDescriptors != null ? this.otherDescriptors.hashCode() : 0);
        return result;
    }
}

