/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.mockfile.HandleTrackingFS;

public class WindowsFS
extends HandleTrackingFS {
    final Map<Object, Integer> openFiles = new HashMap<Object, Integer>();

    public WindowsFS(FileSystem delegate) {
        super("windows://", delegate);
    }

    private Object getKey(Path existing) throws IOException {
        BasicFileAttributeView view = Files.getFileAttributeView(existing, BasicFileAttributeView.class, new LinkOption[0]);
        BasicFileAttributes attributes = view.readAttributes();
        return attributes.fileKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onOpen(Path path, Object stream) throws IOException {
        Map<Object, Integer> map = this.openFiles;
        synchronized (map) {
            Object key = this.getKey(path);
            Integer v = this.openFiles.get(key);
            if (v != null) {
                v = v + 1;
                this.openFiles.put(key, v);
            } else {
                this.openFiles.put(key, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose(Path path, Object stream) throws IOException {
        Object key = this.getKey(path);
        Map<Object, Integer> map = this.openFiles;
        synchronized (map) {
            Integer v = this.openFiles.get(key);
            assert (v != null);
            if (v != null) {
                if (v == 1) {
                    this.openFiles.remove(key);
                } else {
                    v = v - 1;
                    this.openFiles.put(key, v);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeleteAccess(Path path) throws IOException {
        Object key = null;
        try {
            key = this.getKey(path);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (key != null) {
            Map<Object, Integer> map = this.openFiles;
            synchronized (map) {
                if (this.openFiles.containsKey(key)) {
                    throw new IOException("access denied: " + path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Path path) throws IOException {
        Map<Object, Integer> map = this.openFiles;
        synchronized (map) {
            this.checkDeleteAccess(path);
            super.delete(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Map<Object, Integer> map = this.openFiles;
        synchronized (map) {
            this.checkDeleteAccess(source);
            super.move(source, target, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        Map<Object, Integer> map = this.openFiles;
        synchronized (map) {
            this.checkDeleteAccess(path);
            return super.deleteIfExists(path);
        }
    }
}

