/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class Bounds {
    protected boolean noLongitudeBound = false;
    protected boolean noTopLatitudeBound = false;
    protected boolean noBottomLatitudeBound = false;
    protected Double minLatitude = null;
    protected Double maxLatitude = null;
    protected Double leftLongitude = null;
    protected Double rightLongitude = null;

    public Double getMaxLatitude() {
        return this.maxLatitude;
    }

    public Double getMinLatitude() {
        return this.minLatitude;
    }

    public Double getLeftLongitude() {
        return this.leftLongitude;
    }

    public Double getRightLongitude() {
        return this.rightLongitude;
    }

    public boolean checkNoLongitudeBound() {
        return this.noLongitudeBound;
    }

    public boolean checkNoTopLatitudeBound() {
        return this.noTopLatitudeBound;
    }

    public boolean checkNoBottomLatitudeBound() {
        return this.noBottomLatitudeBound;
    }

    public Bounds addHorizontalCircle(double z) {
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            double latitude = Math.asin(z);
            this.addLatitudeBound(latitude);
        }
        return this;
    }

    public Bounds addLatitudeZone(double latitude) {
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            this.addLatitudeBound(latitude);
        }
        return this;
    }

    public Bounds addLongitudeSlice(double newLeftLongitude, double newRightLongitude) {
        if (!this.noLongitudeBound) {
            this.addLongitudeBound(newLeftLongitude, newRightLongitude);
        }
        return this;
    }

    protected void addLatitudeBound(double latitude) {
        if (!this.noTopLatitudeBound && (this.maxLatitude == null || latitude > this.maxLatitude)) {
            this.maxLatitude = latitude;
        }
        if (!this.noBottomLatitudeBound && (this.minLatitude == null || latitude < this.minLatitude)) {
            this.minLatitude = latitude;
        }
    }

    protected void addLongitudeBound(double newLeftLongitude, double newRightLongitude) {
        if (this.leftLongitude == null && this.rightLongitude == null) {
            this.leftLongitude = newLeftLongitude;
            this.rightLongitude = newRightLongitude;
        } else {
            double adjustedLeftLongitude;
            double adjustedRightLongitude;
            double currentLeftLongitude = this.leftLongitude;
            double currentRightLongitude = this.rightLongitude;
            if (currentRightLongitude < currentLeftLongitude) {
                currentRightLongitude += Math.PI * 2;
            }
            if ((adjustedRightLongitude = newRightLongitude) < (adjustedLeftLongitude = newLeftLongitude)) {
                adjustedRightLongitude += Math.PI * 2;
            }
            if (!(currentLeftLongitude <= adjustedLeftLongitude) || !(currentRightLongitude >= adjustedRightLongitude)) {
                if (currentLeftLongitude >= adjustedLeftLongitude && currentRightLongitude <= adjustedRightLongitude) {
                    this.leftLongitude = newLeftLongitude;
                    this.rightLongitude = newRightLongitude;
                } else {
                    if (currentLeftLongitude > adjustedLeftLongitude) {
                        this.leftLongitude = newLeftLongitude;
                    }
                    if (currentRightLongitude < adjustedRightLongitude) {
                        this.rightLongitude = newRightLongitude;
                    }
                }
            }
        }
        double testRightLongitude = this.rightLongitude;
        if (testRightLongitude < this.leftLongitude) {
            testRightLongitude += Math.PI * 2;
        }
        if (testRightLongitude - this.leftLongitude >= Math.PI) {
            this.noLongitudeBound = true;
            this.leftLongitude = null;
            this.rightLongitude = null;
        }
    }

    protected void addLongitudeBound(double longitude) {
        if (this.leftLongitude == null && this.rightLongitude == null) {
            this.leftLongitude = longitude;
            this.rightLongitude = longitude;
        } else {
            double currentLeftLongitude = this.leftLongitude;
            double currentRightLongitude = this.rightLongitude;
            if (currentRightLongitude < currentLeftLongitude) {
                currentRightLongitude += Math.PI * 2;
            }
            if (longitude < currentLeftLongitude) {
                longitude += Math.PI * 2;
            }
            if (longitude < currentLeftLongitude || longitude > currentRightLongitude) {
                double rightExtensionAmt;
                double leftExtensionAmt = longitude < currentLeftLongitude ? currentLeftLongitude - longitude : currentLeftLongitude + Math.PI * 2 - longitude;
                if (leftExtensionAmt < (rightExtensionAmt = longitude > currentRightLongitude ? longitude - currentRightLongitude : longitude + Math.PI * 2 - currentRightLongitude)) {
                    for (currentLeftLongitude = this.leftLongitude - leftExtensionAmt; currentLeftLongitude <= -Math.PI; currentLeftLongitude += Math.PI * 2) {
                    }
                    this.leftLongitude = currentLeftLongitude;
                } else {
                    for (currentRightLongitude = this.rightLongitude + rightExtensionAmt; currentRightLongitude > Math.PI; currentRightLongitude -= Math.PI * 2) {
                    }
                    this.rightLongitude = currentRightLongitude;
                }
            }
        }
        double testRightLongitude = this.rightLongitude;
        if (testRightLongitude < this.leftLongitude) {
            testRightLongitude += Math.PI * 2;
        }
        if (testRightLongitude - this.leftLongitude >= Math.PI) {
            this.noLongitudeBound = true;
            this.leftLongitude = null;
            this.rightLongitude = null;
        }
    }

    public Bounds addPoint(Vector v) {
        return this.addPoint(v.x, v.y, v.z);
    }

    public Bounds addPoint(double x, double y, double z) {
        if (!this.noLongitudeBound) {
            double longitude = Math.atan2(y, x);
            this.addLongitudeBound(longitude);
        }
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            double latitude = Math.asin(z);
            this.addLatitudeBound(latitude);
        }
        return this;
    }

    public Bounds addPoint(double latitude, double longitude) {
        if (!this.noLongitudeBound) {
            this.addLongitudeBound(longitude);
        }
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            this.addLatitudeBound(latitude);
        }
        return this;
    }

    public Bounds noLongitudeBound() {
        this.noLongitudeBound = true;
        this.leftLongitude = null;
        this.rightLongitude = null;
        return this;
    }

    public Bounds noTopLatitudeBound() {
        this.noTopLatitudeBound = true;
        this.maxLatitude = null;
        return this;
    }

    public Bounds noBottomLatitudeBound() {
        this.noBottomLatitudeBound = true;
        this.minLatitude = null;
        return this;
    }
}

