/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ShortObjectProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShortObjectMap<T>
extends AbstractSet {
    public boolean containsKey(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final T value) {
        return !this.forEachPair(new ShortObjectProcedure<T>(){

            @Override
            public boolean apply(short iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractShortObjectMap<T> copy() {
        return (AbstractShortObjectMap)this.getClass().cast(this.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortObjectMap)) {
            return false;
        }
        final AbstractShortObjectMap other = (AbstractShortObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ShortObjectProcedure(){

            public boolean apply(short key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ShortObjectProcedure(){

            public boolean apply(short key, Object value) {
                return AbstractShortObjectMap.this.containsKey(key) && AbstractShortObjectMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public boolean forEachPair(final ShortObjectProcedure<T> procedure) {
        return this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                return procedure.apply(key, AbstractShortObjectMap.this.get(key));
            }
        });
    }

    public abstract T get(short var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ShortArrayList keyList) {
        this.pairsSortedByValue(keyList, new ArrayList(this.size()));
    }

    public void pairsMatching(final ShortObjectProcedure<T> condition, final ShortArrayList keyList, final List<T> valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ShortObjectProcedure<T>(){

            @Override
            public boolean apply(short key, T value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ShortArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        keyList.sort();
        Object[] tempValueList = new Object[keyList.size()];
        int i = keyList.size();
        while (--i >= 0) {
            tempValueList[i] = this.get(keyList.getQuick(i));
        }
        valueList.clear();
        for (Object value : tempValueList) {
            valueList.add(value);
        }
    }

    public void pairsSortedByValue(ShortArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        this.values(valueList);
        if (!valueList.isEmpty() && !(valueList.get(0) instanceof Comparable)) {
            throw new UnsupportedOperationException("Cannot sort the values; " + valueList.get(0).getClass() + " does not implement Comparable");
        }
        final short[] k = keyList.elements();
        final List<T> valueRef = valueList;
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                Object t1 = valueRef.get(a);
                valueRef.set(a, valueRef.get(b));
                valueRef.set(b, t1);
                short t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                int ab = ((Comparable)valueRef.get(a)).compareTo(valueRef.get(b));
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(short var1, T var2);

    public abstract boolean removeKey(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ShortArrayList theKeys = new ShortArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public List<T> values() {
        ArrayList list = new ArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final List<T> list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                list.add(AbstractShortObjectMap.this.get(key));
                return true;
            }
        });
    }
}

