/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.base;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kitesdk.morphline.api.Record;

public final class FieldExpression {
    private final List fields = new ArrayList();
    private static final String START_TOKEN = "@{";
    private static final char END_TOKEN = '}';

    public FieldExpression(String expression, Config config) {
        int start;
        Preconditions.checkNotNull((Object)expression);
        int from = 0;
        while (from < expression.length() && (start = expression.indexOf(START_TOKEN, from)) >= 0) {
            int end;
            if (from != start) {
                this.fields.add(expression.substring(from, start));
            }
            if ((end = expression.indexOf(125, start + START_TOKEN.length())) < 0) {
                throw new IllegalArgumentException("Missing closing token: }");
            }
            String ref = expression.substring(start + START_TOKEN.length(), end);
            this.fields.add(new Field(ref));
            from = end + 1;
        }
        assert (from <= expression.length());
        if (from < expression.length() || this.fields.size() == 0) {
            this.fields.add(expression.substring(from, expression.length()));
        }
        assert (this.fields.size() > 0);
    }

    public List evaluate(Record record) {
        if (this.fields.size() == 1) {
            Object first = this.fields.get(0);
            if (first instanceof String) {
                return Collections.singletonList(first);
            }
            String ref = ((Field)first).getName();
            if (ref.length() != 0) {
                List resolvedValues = record.get(ref);
                return resolvedValues;
            }
        }
        ArrayList results = new ArrayList(1);
        this.evaluate2(0, record, new StringBuilder(), results);
        return results;
    }

    private void evaluate2(int from, Record record, StringBuilder buf, ArrayList results) {
        if (from >= this.fields.size()) {
            results.add(buf.toString());
            return;
        }
        Object item = this.fields.get(from);
        if (item instanceof String) {
            buf.append(item);
            this.evaluate2(from + 1, record, buf, results);
        } else {
            String ref = ((Field)item).getName();
            if (ref.length() == 0) {
                buf.append(record.toString());
                this.evaluate2(from + 1, record, buf, results);
            } else {
                List resolvedValues = record.get(ref);
                for (Object value : resolvedValues) {
                    StringBuilder buf2 = new StringBuilder(buf);
                    buf2.append(value.toString());
                    this.evaluate2(from + 1, record, buf2, results);
                }
            }
        }
    }

    private static final class Field {
        private final String name;

        public Field(String name) {
            assert (name != null);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Field:" + this.getName();
        }
    }
}

