/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.suffixtree;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongIntOpenHashMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import org.carrot2.text.suffixtree.ISequence;

public final class SuffixTree {
    private static final int NO_SUFFIX_LINK = Integer.MIN_VALUE;
    private static final int LEAF_STATE = -1;
    public static final int NO_EDGE = -1;
    private static final int ROOT_STATE = 1;
    final ISequence sequence;
    private final int inputSize;
    private IntArrayList states = new IntArrayList();
    private final LongIntOpenHashMap transitions_map = new LongIntOpenHashMap();
    private final IntArrayList transitions = new IntArrayList();
    private int s;
    private int k;
    private int i;
    private boolean end_point;
    private final int head;
    private final int root;
    private final int root_transition;
    private final int slots_per_transition;
    private final IStateCallback newStateCallback;

    public SuffixTree(ISequence sequence, IStateCallback newStateCallback, IProgressCallback progressCallback) {
        this.sequence = sequence;
        this.newStateCallback = newStateCallback;
        this.head = this.createState();
        this.root = this.createState();
        this.setSuffixLink(this.root, this.head);
        assert (1 == this.root);
        this.addTransition(this.root, 0, 0);
        this.slots_per_transition = this.transitions.size();
        this.root_transition = 0;
        this.s = this.root;
        this.inputSize = sequence.size();
        this.i = 1;
        this.k = 1;
        while (this.i <= this.inputSize) {
            if (progressCallback != null) {
                progressCallback.next(this.i - 1);
            }
            this.update();
            this.canonize(this.s, this.k, this.i);
            ++this.i;
        }
        for (int i = this.states.size() - 1; i >= 0; --i) {
            this.states.set(i, -1);
        }
        for (LongIntCursor c : this.transitions_map) {
            int g = c.value;
            int state = (int)(c.key >>> 32);
            int prev = this.states.get(state);
            if (prev != -1) {
                this.transitions.set(g + 3, prev);
            }
            this.states.set(state, g);
        }
    }

    private final void update() {
        int oldr = this.root;
        while (true) {
            int r = this.testAndSplit(this.i - 1, this.i);
            if (this.end_point) break;
            this.createTransition(r, this.i, this.inputSize, this.createNewState(this.i));
            if (oldr != this.root) {
                this.setSuffixLink(oldr, r);
            }
            oldr = r;
            this.canonize(this.getSuffixLink(this.s), this.k, this.i - 1);
        }
        if (oldr != this.root) {
            this.setSuffixLink(oldr, this.s);
        }
    }

    private final int testAndSplit(int p, int ti) {
        if (this.k <= p) {
            int g = this.findTransition(this.s, this.k);
            assert (g >= 0);
            int gk = this.transitions.get(g + 1);
            int gj = this.transitions.get(g + 2);
            int gs = this.transitions.get(g);
            if (this.sequence.objectAt(ti - 1) == this.sequence.objectAt(gk + p - this.k)) {
                this.end_point = true;
                return this.s;
            }
            int r = this.createNewState(gk + p - this.k);
            this.reuseTransition(this.removeTransition(this.s, this.k), this.s, gk, gk + p - this.k, r);
            this.createTransition(r, gk + p - this.k + 1, gj, gs);
            this.end_point = false;
            return r;
        }
        this.end_point = this.findTransition(this.s, ti) >= 0;
        return this.s;
    }

    private void canonize(int s, int k, int p) {
        if (p >= k) {
            int d;
            int g = this.findTransition(s, k);
            while (g >= 0 && (d = this.transitions.get(g + 2) - this.transitions.get(g + 1)) <= p - k) {
                k = k + d + 1;
                s = this.transitions.get(g);
                if (k > p) continue;
                g = this.findTransition(s, k);
            }
        }
        this.s = s;
        this.k = k;
    }

    private void setSuffixLink(int fromState, int toState) {
        this.states.set(fromState, toState);
    }

    private int getSuffixLink(int s) {
        int ts = this.states.get(s);
        assert (ts != Integer.MIN_VALUE);
        return ts;
    }

    private final int createNewState(int position) {
        int state = this.createState();
        if (this.newStateCallback != null) {
            this.newStateCallback.newState(state, position);
        }
        return state;
    }

    private final int createState() {
        int state = this.states.size();
        this.states.add(Integer.MIN_VALUE);
        return state;
    }

    private final void createTransition(int s, int k, int p, int ts) {
        assert (k > 0 && p > 0);
        int transition = this.addTransition(ts, k, p);
        this.transitions_map.put(SuffixTree.asLong(s, this.sequence.objectAt(k - 1)), transition);
    }

    private final void reuseTransition(int transition, int s, int k, int p, int ts) {
        assert (k > 0 && p > 0);
        this.transitions.set(transition, ts);
        this.transitions.set(transition + 1, k);
        this.transitions.set(transition + 2, p);
        this.transitions_map.put(SuffixTree.asLong(s, this.sequence.objectAt(k - 1)), transition);
    }

    private final int addTransition(int ts, int k, int p) {
        int transition = this.transitions.size();
        this.transitions.add(ts);
        this.transitions.add(k);
        this.transitions.add(p);
        this.transitions.add(-1);
        return transition;
    }

    private final int findTransition(int s, int k) {
        return s == this.head ? this.root_transition : this.findEdge(s, this.sequence.objectAt(k - 1));
    }

    private int removeTransition(int s, int k) {
        assert (s != this.head);
        return this.transitions_map.remove(SuffixTree.asLong(s, this.sequence.objectAt(k - 1)));
    }

    private static final long asLong(int i1, int i2) {
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public final int getTransitionsCount() {
        return this.transitions.size() / this.slots_per_transition - 1;
    }

    public final int getStatesCount() {
        return this.states.size() - 1;
    }

    public boolean containsSuffix(ISequence seq) {
        int state = this.root;
        int i = 0;
        int edge;
        while ((edge = this.findEdge(state, seq.objectAt(i))) >= 0) {
            int j;
            int m = this.getEndIndex(edge) + 1;
            for (j = this.getStartIndex(edge); i < seq.size() && j < m; ++j, ++i) {
                if (seq.objectAt(i) == this.sequence.objectAt(j)) continue;
                return false;
            }
            if (i == seq.size()) {
                return j == this.inputSize;
            }
            state = this.getToState(edge);
        }
        return false;
    }

    public final void visit(IVisitor visitor) {
        this.visitState(this.root, visitor);
    }

    public final void visitState(int state, IVisitor visitor) {
        if (visitor.pre(state)) {
            int edge = this.firstEdge(state);
            while (edge != -1) {
                int toState = this.transitions.get(edge);
                if (visitor.edge(state, toState, this.getStartIndex(edge), this.getEndIndex(edge))) {
                    this.visitState(toState, visitor);
                }
                edge = this.nextEdge(edge);
            }
            visitor.post(state);
        }
    }

    public int getRootState() {
        return this.root;
    }

    public final boolean isLeaf(int state) {
        return this.states.get(state) == -1;
    }

    public final int firstEdge(int state) {
        return this.states.get(state);
    }

    public final int nextEdge(int edge) {
        return this.transitions.get(edge + 3);
    }

    public final int findEdge(int state, int symbol) {
        return this.transitions_map.containsKey(SuffixTree.asLong(state, symbol)) ? this.transitions_map.lget() : -1;
    }

    public int getToState(int edge) {
        return this.transitions.get(edge);
    }

    public int getStartIndex(int edge) {
        return this.transitions.get(edge + 1) - 1;
    }

    public int getEndIndex(int edge) {
        return this.transitions.get(edge + 2) - 1;
    }

    public static class VisitorAdapter
    implements IVisitor {
        @Override
        public boolean pre(int state) {
            return true;
        }

        @Override
        public void post(int state) {
        }

        @Override
        public boolean edge(int fromState, int toState, int startIndex, int endIndex) {
            return true;
        }
    }

    public static interface IVisitor {
        public boolean pre(int var1);

        public void post(int var1);

        public boolean edge(int var1, int var2, int var3, int var4);
    }

    public static interface IProgressCallback {
        public void next(int var1);
    }

    public static interface IStateCallback {
        public void newState(int var1, int var2);
    }
}

