/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="class-resource")
public final class ClassResource
implements IResource {
    private Class<?> clazz;
    @Attribute(name="classname")
    private String classname;
    @Attribute(name="resource")
    private String resource;

    ClassResource() {
    }

    public ClassResource(Class<?> clazz, String resource) {
        this.classname = clazz.getName();
        this.clazz = clazz;
        this.resource = resource;
    }

    @Override
    public InputStream open() throws IOException {
        if (this.clazz == null) {
            throw new IOException("Could not reinstantiate class: " + this.classname + " from context class loader to " + " load resource: " + this.resource);
        }
        return StreamUtils.prefetch(this.clazz.getResourceAsStream(this.resource));
    }

    @Commit
    void afterDeserialization() throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            this.clazz = Class.forName(this.classname, false, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

