/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.mapper.processor;

import org.apache.commons.lang.StringUtils;
import org.apache.uima.alchemy.digester.domain.AnnotatedResults;
import org.apache.uima.alchemy.digester.domain.Results;
import org.apache.uima.alchemy.mapper.processor.AlchemyOutputProcessor;
import org.apache.uima.alchemy.ts.entity.AlchemyAnnotation;
import org.apache.uima.jcas.JCas;

public class AnnotatedEntitiesProcessor
implements AlchemyOutputProcessor {
    public void process(JCas cas, Results results) throws Exception {
        String[] ants;
        String annotatedText = ((AnnotatedResults)results).getAnnotatedText();
        for (String ant : ants = StringUtils.substringsBetween((String)annotatedText, (String)"[", (String)"]")) {
            if (ant.indexOf("[") <= 0) continue;
            AlchemyAnnotation alchemyAnnotation = new AlchemyAnnotation(cas);
            int indexOfAnt = annotatedText.indexOf(ant);
            alchemyAnnotation.setBegin(indexOfAnt - 1);
            String antText = ant.substring(ant.indexOf("[") + 1);
            alchemyAnnotation.setEnd(indexOfAnt + antText.length() - 1);
            String antType = ant.substring(0, ant.indexOf("["));
            alchemyAnnotation.setAlchemyType(antType);
            alchemyAnnotation.addToIndexes();
            annotatedText = annotatedText.replaceFirst("\\[" + ant.replace("[", "\\[") + "\\]\\]", antText);
        }
    }
}

