/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.service.impl.ServiceDataCargo;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.service.impl.ResourceService_impl;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.impl.ProcessTrace_impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisEngineService_impl
extends ResourceService_impl {
    private CasPool mCasPool;
    private int mTimeout;

    @Override
    public void initialize(ResourceSpecifier aResourceSpecifier, Map<String, Object> aResourceInitParams) throws ResourceInitializationException {
        super.initialize(aResourceSpecifier, aResourceInitParams);
        Integer numInstances = (Integer)aResourceInitParams.get("NUM_SIMULTANEOUS_REQUESTS");
        if (numInstances == null) {
            numInstances = 1;
        }
        this.mCasPool = new CasPool((int)numInstances, this.getAnalysisEngine());
        Integer timeoutInteger = (Integer)aResourceInitParams.get("TIMEOUT_PERIOD");
        this.mTimeout = timeoutInteger != null ? timeoutInteger : 0;
    }

    public void initialize(ResourceSpecifier aResourceSpecifier, int aNumSimultaneousRequests, int aTimeout) throws ResourceInitializationException {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        initParams.put("NUM_SIMULTANEOUS_REQUESTS", aNumSimultaneousRequests);
        initParams.put("TIMEOUT_PERIOD", aTimeout);
        this.initialize(aResourceSpecifier, initParams);
    }

    public ServiceDataCargo process(ServiceDataCargo aData, ResultSpecification aResultSpec) throws ResourceServiceException {
        ProcessTrace trace = aData.getProcessTrace();
        if (trace == null) {
            trace = new ProcessTrace_impl();
        }
        String resourceName = this.getMetaData().getName();
        trace.startEvent(resourceName, "SERVICE", "");
        CAS cas = null;
        String resultMessage = "success";
        try {
            cas = this.getCasFromPool(this.mTimeout);
            if (cas == null) {
                throw new ResourceServiceException("resource_unavailable", new Object[0]);
            }
            aData.unmarshalCas(cas, true);
            this.getAnalysisEngine().process(cas, aResultSpec, trace);
            ServiceDataCargo serviceDataCargo = new ServiceDataCargo(cas, trace);
            return serviceDataCargo;
        }
        catch (Exception e) {
            resultMessage = e.getLocalizedMessage();
            if (e instanceof ResourceServiceException) {
                throw (ResourceServiceException)e;
            }
            throw new ResourceServiceException(e);
        }
        finally {
            if (cas != null) {
                this.getCasPool().releaseCas(cas);
            }
            trace.endEvent(resourceName, "SERVICE", resultMessage);
        }
    }

    public AnalysisEngine getAnalysisEngine() {
        return (AnalysisEngine)this.getResource();
    }

    @Override
    protected Class<? extends Resource> getResourceClass() {
        return AnalysisEngine.class;
    }

    protected CasPool getCasPool() {
        return this.mCasPool;
    }

    protected CAS getCasFromPool(int aTimeout) throws ResourceServiceException {
        CAS cas = this.getCasPool().getCas(aTimeout);
        if (cas == null) {
            throw new ResourceServiceException("resource_unavailable", null);
        }
        return cas;
    }
}

