/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;

public class Serialization {
    public static CASSerializer serializeCAS(CAS cas) {
        CASSerializer ser = new CASSerializer();
        ser.addCAS((CASImpl)cas);
        return ser;
    }

    public static CASSerializer serializeNoMetaData(CAS cas) {
        CASSerializer ser = new CASSerializer();
        ser.addNoMetaData((CASImpl)cas);
        return ser;
    }

    public static CASMgrSerializer serializeCASMgr(CASMgr casMgr) {
        CASMgrSerializer ser = new CASMgrSerializer();
        ser.addTypeSystem((TypeSystemImpl)casMgr.getCAS().getTypeSystem());
        ser.addIndexRepository((FSIndexRepositoryImpl)((CASImpl)casMgr.getCAS()).getBaseIndexRepository());
        return ser;
    }

    public static CASCompleteSerializer serializeCASComplete(CASMgr casMgr) {
        return new CASCompleteSerializer((CASImpl)casMgr);
    }

    public static void deserializeCASComplete(CASCompleteSerializer casCompSer, CASMgr casMgr) {
        ((CASImpl)casMgr).reinit(casCompSer);
    }

    public static CASMgr createCASMgr(CASMgrSerializer ser) {
        return new CASImpl(ser);
    }

    public static CAS createCAS(CASMgr casMgr, CASSerializer casSer) {
        ((CASImpl)casMgr).reinit(casSer);
        return ((CASImpl)casMgr).getCurrentView();
    }

    public static void serializeCAS(CAS cas, OutputStream ostream) {
        CASSerializer ser = new CASSerializer();
        ser.addCAS((CASImpl)cas, ostream);
    }

    public static void deserializeCAS(CAS cas, InputStream istream) {
        ((CASImpl)cas).reinit(istream);
    }

    public static void serializeCAS(CAS cas, OutputStream ostream, Marker mark) {
        if (!mark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER");
        }
        CASSerializer ser = new CASSerializer();
        ser.addCAS((CASImpl)cas, ostream, mark);
    }
}

