/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final ArrayList<File> getFiles(File directory, boolean getRecursive) {
        if (!directory.exists() || !directory.isDirectory()) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                if (!getRecursive) continue;
                fileList.addAll(FileUtils.getFiles(file, getRecursive));
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    public static final ArrayList<File> getFiles(File directory) {
        return FileUtils.getFiles(directory, false);
    }

    public static final ArrayList<File> getSubDirs(File directory) {
        if (!directory.exists() || !directory.isDirectory()) {
            return null;
        }
        ArrayList<File> dirList = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (!file.isDirectory()) continue;
            dirList.add(file);
        }
        return dirList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader2String(Reader reader) throws IOException {
        StringBuffer strBuffer = new StringBuffer();
        char[] buf = new char[10000];
        try {
            int charsRead;
            while ((charsRead = reader.read(buf)) >= 0) {
                strBuffer.append(buf, 0, charsRead);
            }
        }
        finally {
            reader.close();
        }
        return strBuffer.toString();
    }

    public static String file2String(File file) throws IOException {
        return FileUtils.reader2String(new FileReader(file));
    }

    public static String file2String(File file, String fileEncoding) throws IOException {
        if (fileEncoding == null) {
            return FileUtils.file2String(file);
        }
        return FileUtils.reader2String(new InputStreamReader((InputStream)new FileInputStream(file), fileEncoding));
    }

    public static void saveString2File(String fileContents, File file) throws IOException {
        FileUtils.saveString2File(fileContents, file, Charset.defaultCharset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString2File(String s, File file, String encoding) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            writer.write(s);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static final void deleteAllFiles(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    public static final boolean deleteRecursive(File file) {
        if (!file.exists()) {
            return false;
        }
        boolean rc = true;
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                rc &= FileUtils.deleteRecursive(fileList[i]);
            }
        }
        return rc &= file.delete();
    }

    public static final boolean mkdir(File directory) {
        if (directory.exists()) {
            return false;
        }
        return directory.mkdir();
    }

    public static final File createTempDir(File parent, String prefix) {
        File tempDir;
        Random rand = new Random();
        while ((tempDir = new File(parent, prefix + rand.nextInt())).exists()) {
        }
        if (tempDir.mkdirs()) {
            tempDir.deleteOnExit();
            return tempDir;
        }
        return null;
    }

    public static final File createTempFile(String prefix, String suffix, File tempDir) throws IOException {
        File file = File.createTempFile(prefix, suffix, tempDir);
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(File file, File dir) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("File does not exist or is not readable: " + file.getAbsolutePath());
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Destination does not exist or is not a directory: " + dir.getAbsolutePath());
        }
        File outFile = new File(dir, file.getName());
        if (outFile.exists() && !outFile.canWrite()) {
            throw new IOException("Can't write output file: " + outFile);
        }
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int count;
            is = new FileInputStream(file);
            os = new FileOutputStream(outFile);
            while (0 <= (count = is.read(bytes))) {
                os.write(bytes, 0, count);
            }
        }
        finally {
            if (null != is) {
                is.close();
            }
            if (null != os) {
                os.close();
            }
        }
    }

    public static String findRelativePath(File file, File relativeToDir) throws IOException {
        int j;
        String canonicalFile = file.getCanonicalPath();
        String canonicalRelTo = relativeToDir.getCanonicalPath();
        String[] filePathComponents = FileUtils.getPathComponents(canonicalFile);
        String[] relToPathComponents = FileUtils.getPathComponents(canonicalRelTo);
        for (int i = 0; i < filePathComponents.length && i < relToPathComponents.length && filePathComponents[i].equals(relToPathComponents[i]); ++i) {
        }
        StringBuffer buf = new StringBuffer();
        for (j = i; j < relToPathComponents.length; ++j) {
            buf.append("../");
        }
        for (j = i; j < filePathComponents.length - 1; ++j) {
            buf.append(filePathComponents[j]).append('/');
        }
        buf.append(filePathComponents[filePathComponents.length - 1]);
        return buf.toString();
    }

    public static String[] getPathComponents(String canonicalPath) {
        String regex = File.separator;
        if (regex.equals("\\")) {
            regex = "\\\\";
        }
        return canonicalPath.split(regex);
    }
}

