/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import com.google.common.base.Charsets;
import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class ConvertHTMLBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("convertHTML");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new ConvertHTML(this, config, parent, child, context);
        }
        catch (SAXNotRecognizedException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
    }

    private static final class ConvertHTML
    extends AbstractParser {
        private final Charset charset;
        private final boolean omitXMLDeclaration;
        private final XMLReader xmlReader;
        private final HTMLSchema htmlSchema = new HTMLSchema();

        public ConvertHTML(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws SAXNotRecognizedException, SAXNotSupportedException {
            super(builder, config, parent, child, context);
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.omitXMLDeclaration = this.getConfigs().getBoolean(config, "omitXMLDeclaration", false);
            this.xmlReader = new Parser();
            this.xmlReader.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", this.htmlSchema);
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/cdata-elements", this.getConfigs().getBoolean(config, "noCDATA", false));
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", !this.getConfigs().getBoolean(config, "noNamespaces", true));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", this.getConfigs().getBoolean(config, "noBogons", false));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", this.getConfigs().getBoolean(config, "emptyBogons", false));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", this.getConfigs().getBoolean(config, "noRootBogons", false));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", this.getConfigs().getBoolean(config, "noDefaultAttributes", false));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/translate-colons", this.getConfigs().getBoolean(config, "noColons", false));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/restart-elements", this.getConfigs().getBoolean(config, "noRestart", false));
            this.xmlReader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", !this.getConfigs().getBoolean(config, "suppressIgnorableWhitespace", true));
            this.validateArguments();
        }

        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            try {
                return this.doProcess2(inputRecord, stream);
            }
            catch (SAXNotRecognizedException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            catch (SAXNotSupportedException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            catch (SAXException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
        }

        private boolean doProcess2(Record inputRecord, InputStream stream) throws IOException, SAXException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            XMLWriter xmlWriter = new XMLWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)out, Charsets.UTF_8)));
            xmlWriter.setOutputProperty("encoding", "UTF-8");
            if (this.omitXMLDeclaration) {
                xmlWriter.setOutputProperty("omit-xml-declaration", "yes");
            }
            this.xmlReader.setContentHandler((ContentHandler)xmlWriter);
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputSource source = new InputSource(new BufferedReader(new InputStreamReader(stream, detectedCharset)));
            this.xmlReader.parse(source);
            Record outputRecord = inputRecord.copy();
            ConvertHTML.removeAttachments((Record)outputRecord);
            outputRecord.replaceValues("_attachment_body", (Object)out.toByteArray());
            this.incrementNumRecords();
            return this.getChild().process(outputRecord);
        }
    }
}

