/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.hadoop.HeartBeater;
import org.apache.solr.hadoop.SolrInputDocumentWritable;
import org.apache.solr.hadoop.SolrRecordWriter;
import org.apache.solr.hadoop.dedup.NoChangeUpdateConflictResolver;
import org.apache.solr.hadoop.dedup.RetainMostRecentUpdateConflictResolver;
import org.apache.solr.hadoop.dedup.UpdateConflictResolver;
import org.kitesdk.morphline.api.ExceptionHandler;
import org.kitesdk.morphline.base.FaultTolerance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrReducer
extends Reducer<Text, SolrInputDocumentWritable, Text, SolrInputDocumentWritable> {
    private UpdateConflictResolver resolver;
    private HeartBeater heartBeater;
    private ExceptionHandler exceptionHandler;
    public static final String UPDATE_CONFLICT_RESOLVER = SolrReducer.class.getName() + ".updateConflictResolver";
    private static final Logger LOG = LoggerFactory.getLogger(SolrReducer.class);

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.verifyPartitionAssignment(context);
        SolrRecordWriter.addReducerContext(context);
        Class resolverClass = context.getConfiguration().getClass(UPDATE_CONFLICT_RESOLVER, RetainMostRecentUpdateConflictResolver.class, UpdateConflictResolver.class);
        this.resolver = (UpdateConflictResolver)ReflectionUtils.newInstance((Class)resolverClass, (Configuration)context.getConfiguration());
        this.exceptionHandler = new FaultTolerance(context.getConfiguration().getBoolean("isProductionMode", false), context.getConfiguration().getBoolean("isIgnoringRecoverableExceptions", false), context.getConfiguration().get("recoverableExceptionClasses", SolrServerException.class.getName()));
        this.heartBeater = new HeartBeater((Progressable)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reduce(Text key, Iterable<SolrInputDocumentWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        this.heartBeater.needHeartBeat();
        try {
            values = this.resolve(key, values, context);
            super.reduce((Object)key, values, context);
        }
        catch (Exception e) {
            LOG.error("Unable to process key " + key, (Throwable)e);
            context.getCounter(((Object)((Object)this)).getClass().getName() + ".errors", e.getClass().getName()).increment(1L);
            this.exceptionHandler.handleException((Throwable)e, null);
        }
        finally {
            this.heartBeater.cancelHeartBeat();
        }
    }

    private Iterable<SolrInputDocumentWritable> resolve(final Text key, final Iterable<SolrInputDocumentWritable> values, final Reducer.Context context) {
        if (this.resolver instanceof NoChangeUpdateConflictResolver) {
            return values;
        }
        return new Iterable<SolrInputDocumentWritable>(){

            @Override
            public Iterator<SolrInputDocumentWritable> iterator() {
                return new WrapIterator(SolrReducer.this.resolver.orderUpdates(key, new UnwrapIterator(values.iterator()), context));
            }
        };
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.heartBeater.close();
        super.cleanup(context);
    }

    private void verifyPartitionAssignment(Reducer.Context context) {
        if ("true".equals(System.getProperty("verifyPartitionAssignment", "true"))) {
            int taskId;
            int partition;
            String partitionStr = context.getConfiguration().get("mapred.task.partition");
            if (partitionStr == null) {
                partitionStr = context.getConfiguration().get("mapreduce.task.partition");
            }
            Preconditions.checkArgument(((partition = Integer.parseInt(partitionStr)) == (taskId = context.getTaskAttemptID().getTaskID().getId()) ? 1 : 0) != 0, (Object)("mapred.task.partition: " + partition + " not equal to reducer taskId: " + taskId));
        }
    }

    private static final class UnwrapIterator
    implements Iterator<SolrInputDocument> {
        private Iterator<SolrInputDocumentWritable> parent;

        private UnwrapIterator(Iterator<SolrInputDocumentWritable> parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public SolrInputDocument next() {
            return this.parent.next().getSolrInputDocument();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class WrapIterator
    implements Iterator<SolrInputDocumentWritable> {
        private Iterator<SolrInputDocument> parent;

        private WrapIterator(Iterator<SolrInputDocument> parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public SolrInputDocumentWritable next() {
            return new SolrInputDocumentWritable(this.parent.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

