/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.uima.processor.FieldMappingException;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIMAToSolrMapper {
    private final Logger log = LoggerFactory.getLogger(UIMAToSolrMapper.class);
    private final SolrInputDocument document;
    private final JCas cas;

    public UIMAToSolrMapper(SolrInputDocument document, JCas cas) {
        this.document = document;
        this.cas = cas;
    }

    void map(String typeName, Map<String, SolrUIMAConfiguration.MapField> featureFieldsmapping) throws FieldMappingException {
        try {
            Type type = this.cas.getTypeSystem().getType(typeName);
            FSIterator iterator = this.cas.getFSIndexRepository().getAllIndexedFS(type);
            while (iterator.hasNext()) {
                FeatureStructure fs = (FeatureStructure)iterator.next();
                for (String featureName : featureFieldsmapping.keySet()) {
                    SolrUIMAConfiguration.MapField mapField = featureFieldsmapping.get(featureName);
                    String fieldNameFeature = mapField.getFieldNameFeature();
                    String fieldNameFeatureValue = fieldNameFeature == null ? null : fs.getFeatureValueAsString(type.getFeatureByBaseName(fieldNameFeature));
                    String fieldName = mapField.getFieldName(fieldNameFeatureValue);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("mapping {}@{} to {}", new Object[]{typeName, featureName, fieldName});
                    }
                    String featureValue = fs instanceof Annotation && "coveredText".equals(featureName) ? ((Annotation)fs).getCoveredText() : fs.getFeatureValueAsString(type.getFeatureByBaseName(featureName));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("writing {} in {}", new Object[]{featureValue, fieldName});
                    }
                    this.document.addField(fieldName, (Object)featureValue, 1.0f);
                }
            }
        }
        catch (Exception e) {
            throw new FieldMappingException(e);
        }
    }
}

