/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.solr.common.util.DataInputInputStream;

public class FastInputStream
extends DataInputInputStream {
    protected final InputStream in;
    protected final byte[] buf;
    protected int pos;
    protected int end;
    protected long readFromStream;

    public FastInputStream(InputStream in) {
        this(in, new byte[8192], 0, 0);
    }

    public FastInputStream(InputStream in, byte[] tempBuffer, int start, int end) {
        this.in = in;
        this.buf = tempBuffer;
        this.pos = start;
        this.end = end;
    }

    public static FastInputStream wrap(InputStream in) {
        return in instanceof FastInputStream ? (FastInputStream)in : new FastInputStream(in);
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int peek() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                return -1;
            }
        }
        return this.buf[this.pos] & 0xFF;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                throw new EOFException();
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int readWrappedStream(byte[] target, int offset, int len) throws IOException {
        return this.in.read(target, offset, len);
    }

    public long position() {
        return this.readFromStream - (long)(this.end - this.pos);
    }

    public void refill() throws IOException {
        this.end = this.readWrappedStream(this.buf, 0, this.buf.length);
        if (this.end > 0) {
            this.readFromStream += (long)this.end;
        }
        this.pos = 0;
    }

    @Override
    public int available() throws IOException {
        return this.end - this.pos;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getPositionInBuffer() {
        return this.pos;
    }

    public int getEndInBuffer() {
        return this.end;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        if (this.end - this.pos > 0) {
            r = Math.min(this.end - this.pos, len);
            System.arraycopy(this.buf, this.pos, b, off, r);
            this.pos += r;
        }
        if (r == len) {
            return r;
        }
        if (len - r >= this.buf.length) {
            int ret = this.readWrappedStream(b, off + r, len - r);
            if (ret >= 0) {
                this.readFromStream += (long)ret;
                return r += ret;
            }
            return r > 0 ? r : -1;
        }
        this.refill();
        if (this.end - this.pos > 0) {
            int toRead = Math.min(this.end - this.pos, len - r);
            System.arraycopy(this.buf, this.pos, b, off + r, toRead);
            this.pos += toRead;
            return r += toRead;
        }
        return r > 0 ? r : -1;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int ret = this.read(b, off, len);
            if (ret == -1) {
                throw new EOFException();
            }
            off += ret;
            len -= ret;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.end - this.pos >= n) {
            this.pos += n;
            return n;
        }
        if (this.end - this.pos < 0) {
            return -1;
        }
        int r = this.end - this.pos;
        this.pos = this.end;
        while (r < n) {
            this.refill();
            if (this.end - this.pos <= 0) {
                return r;
            }
            int toRead = Math.min(this.end - this.pos, n - r);
            r += toRead;
            this.pos += toRead;
        }
        return r;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                throw new EOFException();
            }
        }
        return this.buf[this.pos++];
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    @Override
    public long readLong() throws IOException {
        return (long)this.readUnsignedByte() << 56 | (long)this.readUnsignedByte() << 48 | (long)this.readUnsignedByte() << 40 | (long)this.readUnsignedByte() << 32 | (long)this.readUnsignedByte() << 24 | (long)(this.readUnsignedByte() << 16) | (long)(this.readUnsignedByte() << 8) | (long)this.readUnsignedByte();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }
}

