/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.carrot2.util.attribute.AnnotationsPredicate;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.BindableMetadata;
import org.carrot2.util.attribute.BindableUtils;
import org.carrot2.util.attribute.Input;

public class BindableDescriptor {
    public final GroupingMethod groupedBy;
    public final Class<?> type;
    public final String prefix;
    public final Map<String, AttributeDescriptor> attributeDescriptors;
    public final Map<Object, Map<String, AttributeDescriptor>> attributeGroups;
    final Map<String, AttributeDescriptor> attributeDescriptorsInternal;
    final Map<Field, BindableDescriptor> bindableDescriptorsInternal;
    public final BindableMetadata metadata;
    static IGrouper<Class<?>> GROUPER_BY_STRUCTURE = new IGrouper<Class<?>>(){

        @Override
        public Class<?> getGroupingObject(BindableDescriptor bindableDescriptor, AttributeDescriptor attributeDescriptor) {
            return attributeDescriptor.attributeField.getDeclaringClass();
        }
    };
    static IGrouper<AttributeLevel> GROUPER_BY_LEVEL = new IGrouper<AttributeLevel>(){

        @Override
        public AttributeLevel getGroupingObject(BindableDescriptor bindableDescriptor, AttributeDescriptor attributeDescriptor) {
            if (attributeDescriptor.metadata != null) {
                return attributeDescriptor.metadata.getLevel();
            }
            return null;
        }
    };
    static IGrouper<String> GROUPER_BY_GROUP = new IGrouper<String>(){

        @Override
        public String getGroupingObject(BindableDescriptor bindableDescriptor, AttributeDescriptor attributeDescriptor) {
            if (attributeDescriptor.metadata != null) {
                return attributeDescriptor.metadata.getGroup();
            }
            return null;
        }
    };
    static IGrouper<String> GROUPER_BY_NONE = new IGrouper<String>(){

        @Override
        public String getGroupingObject(BindableDescriptor bindableDescriptor, AttributeDescriptor attributeDescriptor) {
            return null;
        }
    };

    BindableDescriptor(Class<?> bindableType, BindableMetadata metadata, Map<Field, BindableDescriptor> bindableDescriptors, Map<String, AttributeDescriptor> attributeDescriptors) {
        this(bindableType, metadata, bindableDescriptors, attributeDescriptors, GroupingMethod.NONE);
    }

    BindableDescriptor(Class<?> bindableType, BindableMetadata metadata, Map<Field, BindableDescriptor> bindableDescriptors, Map<String, AttributeDescriptor> attributeDescriptors, GroupingMethod groupBy) {
        this.type = bindableType;
        this.prefix = BindableUtils.getPrefix(bindableType);
        this.metadata = metadata;
        this.bindableDescriptorsInternal = bindableDescriptors;
        this.attributeDescriptorsInternal = attributeDescriptors;
        this.groupedBy = groupBy;
        LinkedHashMap newAttributeDescriptors = Maps.newLinkedHashMap();
        LinkedHashMap newAttributeGroups = Maps.newLinkedHashMap();
        BindableDescriptor.buildAttributeGroups(newAttributeDescriptors, newAttributeGroups, this, this.groupedBy);
        this.attributeDescriptors = Collections.unmodifiableMap(newAttributeDescriptors);
        this.attributeGroups = Collections.unmodifiableMap(newAttributeGroups);
    }

    public BindableDescriptor only(Predicate<AttributeDescriptor> predicate) {
        LinkedHashMap filteredAttributeDescriptors = Maps.newLinkedHashMap();
        for (Map.Entry<String, AttributeDescriptor> entry : this.attributeDescriptorsInternal.entrySet()) {
            AttributeDescriptor descriptor = entry.getValue();
            if (!predicate.apply((Object)descriptor)) continue;
            filteredAttributeDescriptors.put(entry.getKey(), descriptor);
        }
        LinkedHashMap filteredBindableDescriptors = Maps.newLinkedHashMap();
        for (Map.Entry<Field, BindableDescriptor> entry : this.bindableDescriptorsInternal.entrySet()) {
            filteredBindableDescriptors.put(entry.getKey(), entry.getValue().only(predicate));
        }
        return new BindableDescriptor(this.type, this.metadata, filteredBindableDescriptors, filteredAttributeDescriptors, this.groupedBy);
    }

    public BindableDescriptor only(Class<? extends Annotation> ... annotationClasses) {
        if (annotationClasses.length == 0) {
            return this;
        }
        return this.only(new AnnotationsPredicate(true, annotationClasses));
    }

    public BindableDescriptor not(Class<? extends Annotation> ... annotationClasses) {
        if (annotationClasses.length == 0) {
            return this;
        }
        return this.only((Predicate<AttributeDescriptor>)Predicates.not((Predicate)new AnnotationsPredicate(false, annotationClasses)));
    }

    public BindableDescriptor flatten() {
        return this.group(GroupingMethod.NONE);
    }

    public BindableDescriptor group(GroupingMethod groupingMethod) {
        if (this.groupedBy.equals((Object)groupingMethod)) {
            return this;
        }
        return new BindableDescriptor(this.type, this.metadata, this.bindableDescriptorsInternal, this.attributeDescriptorsInternal, groupingMethod);
    }

    public HashMap<String, Object> getDefaultValues() {
        HashMap values = Maps.newHashMap();
        for (AttributeDescriptor d : this.only(new Class[]{Input.class}).flatten().attributeDescriptors.values()) {
            if (d.defaultValue == null && !d.requiredAttribute) continue;
            values.put(d.key, d.defaultValue);
        }
        return values;
    }

    static void buildAttributeGroups(Map<String, AttributeDescriptor> newAttributeDescriptors, Map<Object, Map<String, AttributeDescriptor>> newAttributeGroups, BindableDescriptor bindableDescriptor, GroupingMethod groupingMethod) {
        List sortedGroupKeys;
        HashMap unsortedGroups = Maps.newHashMap();
        if (GroupingMethod.STRUCTURE.equals((Object)groupingMethod)) {
            BindableDescriptor.addGroups(bindableDescriptor, newAttributeDescriptors, unsortedGroups, GROUPER_BY_STRUCTURE);
            sortedGroupKeys = Lists.newArrayList(unsortedGroups.keySet());
            Collections.sort(sortedGroupKeys, ClassComparator.INSTANCE);
        } else if (GroupingMethod.LEVEL.equals((Object)groupingMethod)) {
            BindableDescriptor.addGroups(bindableDescriptor, newAttributeDescriptors, unsortedGroups, GROUPER_BY_LEVEL);
            sortedGroupKeys = Lists.newArrayList(unsortedGroups.keySet());
            Collections.sort(sortedGroupKeys);
        } else if (GroupingMethod.GROUP.equals((Object)groupingMethod)) {
            BindableDescriptor.addGroups(bindableDescriptor, newAttributeDescriptors, unsortedGroups, GROUPER_BY_GROUP);
            sortedGroupKeys = Lists.newArrayList(unsortedGroups.keySet());
            Collections.sort(sortedGroupKeys);
        } else if (GroupingMethod.NONE.equals((Object)groupingMethod)) {
            BindableDescriptor.addGroups(bindableDescriptor, newAttributeDescriptors, unsortedGroups, GROUPER_BY_NONE);
            sortedGroupKeys = Collections.EMPTY_LIST;
        } else {
            throw new IllegalArgumentException("Unknown grouping method: " + (Object)((Object)groupingMethod));
        }
        for (Object object : sortedGroupKeys) {
            newAttributeGroups.put(object, (Map<String, AttributeDescriptor>)unsortedGroups.get(object));
        }
    }

    private static <T> void addGroups(BindableDescriptor sourceBindableDescriptor, Map<String, AttributeDescriptor> newAttributeDescriptors, Map<Object, Map<String, AttributeDescriptor>> newAttributeGroups, IGrouper<T> grouper) {
        for (AttributeDescriptor attributeDescriptor : sourceBindableDescriptor.attributeDescriptorsInternal.values()) {
            BindableDescriptor.addToMaps(newAttributeDescriptors, newAttributeGroups, attributeDescriptor, grouper.getGroupingObject(sourceBindableDescriptor, attributeDescriptor));
        }
        for (Map.Entry entry : sourceBindableDescriptor.bindableDescriptorsInternal.entrySet()) {
            BindableDescriptor.addGroups((BindableDescriptor)entry.getValue(), newAttributeDescriptors, newAttributeGroups, grouper);
        }
    }

    private static <T> void addToMaps(Map<String, AttributeDescriptor> newAttributeDescriptors, Map<Object, Map<String, AttributeDescriptor>> groups, AttributeDescriptor attributeDescriptor, T groupingObject) {
        if (groupingObject == null) {
            newAttributeDescriptors.put(attributeDescriptor.key, attributeDescriptor);
        } else {
            LinkedHashMap map = groups.get(groupingObject);
            if (map == null) {
                map = Maps.newLinkedHashMap();
                groups.put(groupingObject, map);
            }
            map.put(attributeDescriptor.key, attributeDescriptor);
        }
    }

    private static class ClassComparator
    implements Comparator<Class<?>> {
        public static final ClassComparator INSTANCE = new ClassComparator();

        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    }

    static interface IGrouper<T> {
        public T getGroupingObject(BindableDescriptor var1, AttributeDescriptor var2);
    }

    public static enum GroupingMethod {
        STRUCTURE("Declaring class"),
        LEVEL("Attribute level"),
        GROUP("Attribute semantics"),
        NONE("None");

        private final String label;

        private GroupingMethod(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

