/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoDegenerateLatitudeZone
extends GeoBBoxBase {
    public final double latitude;
    public final double sinLatitude;
    public final Plane plane;
    public final GeoPoint interiorPoint;
    public final GeoPoint[] edgePoints;
    public static final GeoPoint[] planePoints = new GeoPoint[0];

    public GeoDegenerateLatitudeZone(double latitude) {
        this.latitude = latitude;
        this.sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        this.plane = new Plane(this.sinLatitude);
        this.interiorPoint = new GeoPoint(cosLatitude, 0.0, this.sinLatitude);
        this.edgePoints = new GeoPoint[]{this.interiorPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.latitude + angle;
        double newBottomLat = this.latitude - angle;
        return GeoBBoxFactory.makeGeoBBox(newTopLat, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(Vector point) {
        return Math.abs(point.z - this.sinLatitude) < 1.0E-10;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return Math.abs(z - this.sinLatitude) < 1.0E-10;
    }

    @Override
    public double getRadius() {
        return Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.plane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noLongitudeBound().addLatitudeZone(this.latitude);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (path.intersects(this.plane, planePoints, new Membership[0])) {
            return 2;
        }
        if (path.isWithin(this.interiorPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateLatitudeZone)) {
            return false;
        }
        GeoDegenerateLatitudeZone other = (GeoDegenerateLatitudeZone)o;
        return other.latitude == this.latitude;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoDegenerateLatitudeZone: {lat=" + this.latitude + "(" + this.latitude * 180.0 / Math.PI + ")}";
    }
}

