/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.carrot2.util.ExceptionUtils;

public final class StringUtils {
    private static final Pattern CAMEL_CASE_FRAGMENT = Pattern.compile("([A-Z]{1,}(?=[0-9]+))|([A-Z]{1,}(?=[A-Z][a-z0-9]+))|([A-Z]?[A-Z]+[a-z0-9]+)|([0-9]+)");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<.+?>", 2);

    private StringUtils() {
    }

    public static <T> String toString(Iterable<T> iterable, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T object = iterator.next();
            stringBuilder.append(object);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

    public static String splitCamelCase(String camelCaseString) {
        return CAMEL_CASE_FRAGMENT.matcher(camelCaseString).replaceAll("$0 ").trim();
    }

    public static String urlEncodeWrapException(String string, String encoding) {
        try {
            return URLEncoder.encode(string, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }

    public static String removeHtmlTags(String string) {
        return HTML_TAG_PATTERN.matcher(string).replaceAll("");
    }

    public static String identifierToHumanReadable(String string) {
        return WordUtils.capitalizeFully((String)string.replace('_', ' '));
    }

    public static String join(String delim, Object ... objects) {
        StringBuilder b = new StringBuilder();
        for (Object s : objects) {
            if (s == null) continue;
            if (b.length() > 0) {
                b.append(delim);
            }
            b.append(s.toString());
        }
        return b.toString();
    }
}

