/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.mapper.processor;

import java.util.List;
import org.apache.uima.alchemy.digester.domain.Concept;
import org.apache.uima.alchemy.digester.domain.ConceptResults;
import org.apache.uima.alchemy.digester.domain.Results;
import org.apache.uima.alchemy.mapper.processor.AlchemyOutputProcessor;
import org.apache.uima.alchemy.ts.concept.ConceptFS;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;

public class ConceptTaggingProcessor
implements AlchemyOutputProcessor {
    public void process(JCas cas, Results results) throws Exception {
        ConceptResults conceptResults = (ConceptResults)results;
        if (conceptResults.getConcepts() != null) {
            List<Concept> concepts = conceptResults.getConcepts().getConcepts();
            for (Concept concept : concepts) {
                ConceptFS conceptFS = new ConceptFS(cas);
                Type type = conceptFS.getType();
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("text"), concept.getText());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("relevance"), concept.getRelevance());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("website"), concept.getWebsite());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("geo"), concept.getGeo());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("dbpedia"), concept.getDbpedia());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("yago"), concept.getYago());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("opencyc"), concept.getOpencyc());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("ciaFactbook"), concept.getCiaFactbook());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("geonames"), concept.getGeonames());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("crunchbase"), concept.getCrunchbase());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("semanticCrunchbase"), concept.getSemanticCrunchbase());
                conceptFS.setFeatureValueFromString(type.getFeatureByBaseName("musicBrainz"), concept.getMusicBrainz());
                conceptFS.addToIndexes();
            }
        }
    }
}

