/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.morphlines.solr;

import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SafeConcurrentUpdateSolrClient
extends ConcurrentUpdateSolrClient {
    private Throwable currentException = null;
    private final Object myLock = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeConcurrentUpdateSolrClient.class);

    public SafeConcurrentUpdateSolrClient(String solrServerUrl, int queueSize, int threadCount) {
        this(solrServerUrl, null, queueSize, threadCount);
    }

    public SafeConcurrentUpdateSolrClient(String solrServerUrl, HttpClient client, int queueSize, int threadCount) {
        super(solrServerUrl, client, queueSize, threadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Throwable ex) {
        assert (ex != null);
        Object object = this.myLock;
        synchronized (object) {
            this.currentException = ex;
        }
        LOGGER.error("handleError", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilFinished() {
        super.blockUntilFinished();
        Object object = this.myLock;
        synchronized (object) {
            if (this.currentException != null) {
                throw new RuntimeException(this.currentException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearException() {
        Object object = this.myLock;
        synchronized (object) {
            this.currentException = null;
        }
    }
}

