/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.FieldExpression;

abstract class AbstractAddValuesCommand
extends AbstractCommand {
    private final Set<Map.Entry<String, Object>> entrySet;

    public AbstractAddValuesCommand(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
        super(builder, config, parent, child, context);
        this.entrySet = new Configs().getEntrySet(config);
        for (Map.Entry<String, Object> entry : this.entrySet) {
            if (entry.getValue() instanceof Collection) continue;
            entry.setValue(new FieldExpression(entry.getValue().toString(), this.getConfig()));
        }
    }

    @Override
    protected boolean doProcess(Record record) {
        for (Map.Entry<String, Object> entry : this.entrySet) {
            String fieldName = entry.getKey();
            this.prepare(record, fieldName);
            Object entryValue = entry.getValue();
            Collection results = entryValue instanceof Collection ? (Collection)entryValue : ((FieldExpression)entryValue).evaluate(record);
            this.putAll(record, fieldName, results);
        }
        return super.doProcess(record);
    }

    protected void prepare(Record record, String key) {
    }

    protected void putAll(Record record, String key, Collection values) {
        record.getFields().putAll((Object)key, (Iterable)values);
    }

    protected void put(Record record, String key, Object value) {
        record.getFields().put((Object)key, value);
    }
}

