/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.shaded.org.apache.commons.math3.random.RandomGenerator;
import org.kitesdk.morphline.shaded.org.apache.commons.math3.random.Well19937c;

public final class SampleBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("sample");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Sample(this, config, parent, child, context);
    }

    private static final class Sample
    extends AbstractCommand {
        private final double probability;
        private final RandomGenerator prng;
        private long count = 0L;

        public Sample(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.probability = this.getConfigs().getDouble(config, "probability", 1.0);
            if (this.probability < 0.0) {
                throw new MorphlineCompilationException("Probability must not be negative: " + this.probability, config);
            }
            if (this.probability >= 1.0) {
                this.prng = null;
            } else if (config.hasPath("seed")) {
                long seed = this.getConfigs().getLong(config, "seed");
                this.prng = new Well19937c(seed);
            } else {
                SecureRandom rand = new SecureRandom();
                int[] seed = new int[624];
                for (int i = 0; i < seed.length; ++i) {
                    seed[i] = rand.nextInt();
                }
                this.prng = new Well19937c(seed);
            }
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (this.prng != null && this.prng.nextDouble() > this.probability) {
                return true;
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("sampleCount: {}", (Object)this.count);
            }
            ++this.count;
            return super.doProcess(record);
        }
    }
}

