/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;

public final class SeparateAttachmentsBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("separateAttachments");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new SeparateAttachments(this, config, parent, child, context);
    }

    private static final class SeparateAttachments
    extends AbstractCommand {
        public SeparateAttachments(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            List attachments = record.get("_attachment_body");
            List mimeTypes = record.get("_attachment_mimetype");
            List charsets = record.get("_attachment_charset");
            List names = record.get("_attachment_name");
            for (int i = 0; i < attachments.size(); ++i) {
                Record outputRecord = record.copy();
                outputRecord.getFields().replaceValues((Object)"_attachment_body", Collections.singletonList(attachments.get(i)));
                List replacement = i < mimeTypes.size() ? Collections.singletonList(mimeTypes.get(i)) : Collections.EMPTY_LIST;
                outputRecord.getFields().replaceValues((Object)"_attachment_mimetype", replacement);
                replacement = i < charsets.size() ? Collections.singletonList(charsets.get(i)) : Collections.EMPTY_LIST;
                outputRecord.getFields().replaceValues((Object)"_attachment_charset", replacement);
                replacement = i < names.size() ? Collections.singletonList(names.get(i)) : Collections.EMPTY_LIST;
                outputRecord.getFields().replaceValues((Object)"_attachment_name", replacement);
                if (super.doProcess(outputRecord)) continue;
                return false;
            }
            return true;
        }
    }
}

