/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHCacheSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Zipper {
    private static final Logger log = LoggerFactory.getLogger(Zipper.class);
    private final DIHCacheSupport.Relation relation;
    private Comparable parentId;
    private Comparable lastChildId;
    private Iterator<Map<String, Object>> rowIterator;
    private PeekingIterator<Map<String, Object>> peeker;

    public static Zipper createOrNull(Context context) {
        if ("zipper".equals(context.getEntityAttribute("join"))) {
            DIHCacheSupport.Relation r = new DIHCacheSupport.Relation(context);
            if (r.doKeyLookup) {
                return new Zipper(r);
            }
        }
        return null;
    }

    private Zipper(DIHCacheSupport.Relation relation) {
        this.relation = relation;
    }

    public Map<String, Object> supplyNextChild(Iterator<Map<String, Object>> rowIterator) {
        this.preparePeeker(rowIterator);
        while (this.peeker.hasNext()) {
            Map child;
            Map current = (Map)this.peeker.peek();
            Comparable childId = (Comparable)current.get(this.relation.primaryKey);
            if (this.lastChildId != null && this.lastChildId.compareTo(childId) > 0) {
                throw new IllegalArgumentException("expect increasing foreign keys for " + this.relation + " got: " + this.lastChildId + "," + childId);
            }
            this.lastChildId = childId;
            int cmp = childId.compareTo(this.parentId);
            if (cmp == 0) {
                child = (Map)this.peeker.next();
                assert (child == current) : "peeker should be right but " + current + " != " + child;
                log.trace("yeild child {} entry {}", (Object)this.relation, (Object)current);
                return child;
            }
            if (cmp < 0) {
                child = (Map)this.peeker.next();
                assert (child == current) : "peeker should be right but " + current + " != " + child;
                log.trace("skip child {}, {} > {}", new Object[]{this.relation, this.parentId, childId});
                continue;
            }
            log.trace("childen is over {}, {} < {}", new Object[]{this.relation, this.parentId, current});
            return null;
        }
        return null;
    }

    private void preparePeeker(Iterator<Map<String, Object>> rowIterator) {
        if (this.rowIterator == null) {
            this.rowIterator = rowIterator;
            this.peeker = Iterators.peekingIterator(rowIterator);
        } else assert (this.rowIterator == rowIterator) : "rowIterator should never change but " + this.rowIterator + " supplied before has been changed to " + rowIterator;
    }

    public void onNewParent(Context context) {
        Comparable newParent = (Comparable)context.resolve(this.relation.foreignKey);
        if (this.parentId != null && this.parentId.compareTo(newParent) >= 0) {
            throw new IllegalArgumentException("expect strictly increasing primary keys for " + this.relation + " got: " + this.parentId + "," + newParent);
        }
        log.trace("{}: {}->{}", new Object[]{this.relation, newParent, this.parentId});
        this.parentId = newParent;
    }
}

