/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.util.plugin.SolrCoreAware;

public class SchemaSimilarityFactory
extends SimilarityFactory
implements SolrCoreAware {
    private Similarity similarity;
    private Similarity defaultSimilarity = new DefaultSimilarity();
    private volatile SolrCore core;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(SolrParams args) {
        super.init(args);
        this.similarity = new PerFieldSimilarityWrapper(){

            public Similarity get(String name) {
                FieldType fieldType = SchemaSimilarityFactory.this.core.getLatestSchema().getFieldTypeNoEx(name);
                if (fieldType == null) {
                    return SchemaSimilarityFactory.this.defaultSimilarity;
                }
                Similarity similarity = fieldType.getSimilarity();
                return similarity == null ? SchemaSimilarityFactory.this.defaultSimilarity : similarity;
            }
        };
    }

    @Override
    public Similarity getSimilarity() {
        assert (this.core != null) : "inform must be called first";
        return this.similarity;
    }
}

