/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringEscapeUtils;
import org.dataone.cn.indexer.convert.IConverter;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SolrField
implements ISolrField {
    protected String name = null;
    protected String xpath = null;
    public boolean multivalue = false;
    protected XPathExpression xPathExpression = null;
    private IConverter converter = null;
    private boolean escapeXML = false;
    private boolean combineNodes = false;

    public SolrField() {
    }

    public SolrField(String name, String xpath, boolean multivalue) {
        this(name, xpath, multivalue, null);
    }

    public SolrField(String name, String xpath, boolean multivalue, IConverter converter) {
        this.name = name;
        this.xpath = xpath;
        this.multivalue = multivalue;
        this.converter = converter;
    }

    public SolrField(String name, String xpath) {
        this.name = name;
        this.xpath = xpath;
    }

    @Override
    public void initExpression(XPath xpathObject) {
        try {
            this.setxPathExpression(xpathObject.compile(this.getXpath()));
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    protected XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    protected void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public boolean isMultivalue() {
        return this.multivalue;
    }

    public void setMultivalue(boolean multivalue) {
        this.multivalue = multivalue;
    }

    public IConverter getConverter() {
        return this.converter;
    }

    public void setConverter(IConverter converter) {
        this.converter = converter;
    }

    public boolean isEscapeXML() {
        return this.escapeXML;
    }

    public void setEscapeXML(boolean escapeXML) {
        this.escapeXML = escapeXML;
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        return this.processField(doc, this.getxPathExpression(), this.name, this.converter, this.multivalue, this.escapeXML);
    }

    public List<SolrElementField> processField(Document doc, XPathExpression expression, String name, IConverter converter, boolean multiValued, boolean xmlEscape) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        try {
            if (multiValued) {
                NodeList values = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                for (int i = 0; i < values.getLength(); ++i) {
                    Node n = values.item(i);
                    String nodeValue = n.getNodeValue();
                    if (nodeValue == null) continue;
                    nodeValue = nodeValue.trim();
                    if (converter != null) {
                        nodeValue = converter.convert(nodeValue);
                    }
                    if (xmlEscape) {
                        nodeValue = StringEscapeUtils.escapeXml((String)nodeValue);
                    }
                    fields.add(new SolrElementField(name, nodeValue));
                }
            } else {
                String value = null;
                if (this.combineNodes) {
                    NodeList nodeSet = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < nodeSet.getLength(); ++i) {
                        Node nText;
                        if (i > 0) {
                            sb.append(" ");
                        }
                        if ((nText = nodeSet.item(i)).getNodeValue() == null) continue;
                        sb.append(nText.getNodeValue().trim());
                    }
                    value = sb.toString().trim();
                } else {
                    value = (String)expression.evaluate(doc, XPathConstants.STRING);
                }
                if (converter != null) {
                    value = converter.convert(value);
                }
                if (xmlEscape) {
                    value = StringEscapeUtils.escapeXml((String)value);
                }
                fields.add(new SolrElementField(name, value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fields;
    }

    public boolean isCombineNodes() {
        return this.combineNodes;
    }

    public void setCombineNodes(boolean combineNodes) {
        this.combineNodes = combineNodes;
    }
}

