/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UomOgcMapping {
    METRE((Unit<Length>)SI.METER, "http://www.opengeospatial.org/se/units/metre"),
    FOOT((Unit<Length>)NonSI.FOOT, "http://www.opengeospatial.org/se/units/foot"),
    PIXEL((Unit<Length>)NonSI.PIXEL, "http://www.opengeospatial.org/se/units/pixel");

    private String seString;
    private Unit<Length> unit;

    private UomOgcMapping(Unit<Length> unit, String seString) {
        this.unit = unit;
        this.seString = seString;
    }

    public String toString() {
        return this.seString;
    }

    public String getSEString() {
        return this.seString;
    }

    public Unit<Length> getUnit() {
        return this.unit;
    }

    public static UomOgcMapping get(String seString) throws IllegalArgumentException {
        for (UomOgcMapping uom : UomOgcMapping.values()) {
            if (!uom.getSEString().equals(seString)) continue;
            return uom;
        }
        throw new IllegalArgumentException("'" + seString + "' is not a valid OGC SE standard Unit of Measure");
    }

    public static UomOgcMapping get(Unit<Length> unit) throws IllegalArgumentException {
        for (UomOgcMapping uom : UomOgcMapping.values()) {
            if (!uom.getUnit().equals(unit)) continue;
            return uom;
        }
        throw new IllegalArgumentException("'" + unit + "' is not a valid OGC SE standard Unit of Measure");
    }
}

