/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.wkt.Formatter;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSingleCRS
extends AbstractCRS
implements SingleCRS {
    private static final long serialVersionUID = 1815712797774273L;
    protected final Datum datum;

    public AbstractSingleCRS(SingleCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.datum = crs.getDatum();
    }

    public AbstractSingleCRS(Map<String, ?> properties, Datum datum, CoordinateSystem cs) {
        super(properties, cs);
        this.datum = datum;
        AbstractSingleCRS.ensureNonNull("datum", datum);
    }

    public Datum getDatum() {
        return this.datum;
    }

    public int getDimension() {
        return this.coordinateSystem.getDimension();
    }

    public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
        return this.coordinateSystem.getAxis(dimension);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractSingleCRS that = (AbstractSingleCRS)object;
            return AbstractSingleCRS.equals((IdentifiedObject)this.datum, (IdentifiedObject)that.datum, compareMetadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.datum.hashCode();
    }

    @Override
    final void formatDefaultWKT(Formatter formatter) {
        formatter.append((IdentifiedObject)this.datum);
        super.formatDefaultWKT(formatter);
    }
}

