/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.metadata.rdf.jena;

import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import com.ibm.lsid.client.metadata.LSIDMetadataFactory;
import com.ibm.lsid.client.metadata.rdf.jena.MemJenaMetadataStore;
import java.util.Hashtable;

public class JenaMetadataFactory
implements LSIDMetadataFactory {
    public static final String MODEL_TYPE = "model-type";
    public static final String ONE_STORE = "one-store";
    public static final String MEM_MODEL = "memory";
    private String modelType = null;
    private boolean oneStore = true;
    MemJenaMetadataStore memStore = null;

    public LSIDMetadata createInstance() throws LSIDMetadataException {
        if (this.modelType == null) {
            throw new LSIDMetadataException("Jena Model type not set in meta data factory: use setProperties");
        }
        if (this.modelType.equals(MEM_MODEL)) {
            if (this.memStore == null || !this.oneStore) {
                this.memStore = new MemJenaMetadataStore();
            }
            return this.memStore;
        }
        throw new LSIDMetadataException("Unsupported Jena Model type in meta data factory: " + this.modelType);
    }

    public void setProperties(Hashtable properties) throws LSIDMetadataException {
        String oneStoreStr;
        this.modelType = (String)properties.get(MODEL_TYPE);
        if (this.modelType == null) {
            this.modelType = MEM_MODEL;
        }
        if ((oneStoreStr = (String)properties.get(ONE_STORE)) != null) {
            this.oneStore = Boolean.valueOf(oneStoreStr);
        }
    }
}

