/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.utils.Key;
import org.quartz.utils.TriggerStatus;

public class StdJDBCDelegate
implements DriverDelegate,
StdJDBCConstants {
    protected Log logger = null;
    protected String tablePrefix = "QRTZ_";
    protected String instanceId;
    protected boolean useProperties;

    public StdJDBCDelegate(Log logger, String tablePrefix, String instanceId) {
        this.logger = logger;
        this.tablePrefix = tablePrefix;
        this.instanceId = instanceId;
    }

    public StdJDBCDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        this.logger = logger;
        this.tablePrefix = tablePrefix;
        this.instanceId = instanceId;
        this.useProperties = useProperties;
    }

    protected boolean canUseProperties() {
        return this.useProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerStatesFromOtherStates(Connection conn, String newState, String oldState1, String oldState2) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_STATE = ? OR TRIGGER_STATE = ?"));
            ps.setString(1, newState);
            ps.setString(2, oldState1);
            ps.setString(3, oldState2);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectMisfiredTriggers(Connection conn, long ts) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? ORDER BY NEXT_FIRE_TIME ASC"));
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>();
            while (rs.next()) {
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                list.add(new Key(triggerName, groupName));
            }
            Object[] oArr = list.toArray();
            Key[] kArr = new Key[oArr.length];
            System.arraycopy(oArr, 0, kArr, 0, oArr.length);
            Key[] keyArray = kArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectTriggersInState(Connection conn, String state) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Key[] sArr;
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ?"));
            ps.setString(1, state);
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>();
            while (rs.next()) {
                list.add(new Key(rs.getString(1), rs.getString(2)));
            }
            Key[] keyArray = sArr = list.toArray(new Key[list.size()]);
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectMisfiredTriggersInState(Connection conn, String state, long ts) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC"));
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            ps.setString(2, state);
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>();
            while (rs.next()) {
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                list.add(new Key(triggerName, groupName));
            }
            Object[] oArr = list.toArray();
            Key[] kArr = new Key[oArr.length];
            System.arraycopy(oArr, 0, kArr, 0, oArr.length);
            Key[] keyArray = kArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectMisfiredTriggersInStates(Connection conn, String state1, String state2, long ts, int count, List resultList) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND ((TRIGGER_STATE = ?) OR (TRIGGER_STATE = ?)) ORDER BY NEXT_FIRE_TIME ASC"));
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            ps.setString(2, state1);
            ps.setString(3, state2);
            rs = ps.executeQuery();
            boolean hasReachedLimit = false;
            while (rs.next() && !hasReachedLimit) {
                if (resultList.size() == count) {
                    hasReachedLimit = true;
                    continue;
                }
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                resultList.add(new Key(triggerName, groupName));
            }
            boolean bl = hasReachedLimit;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    public int countMisfiredTriggersInStates(Connection conn, String state1, String state2, long ts) throws SQLException {
        block3: {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND ((TRIGGER_STATE = ?) OR (TRIGGER_STATE = ?))"));
                ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
                ps.setString(2, state1);
                ps.setString(3, state2);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                int n = rs.getInt(1);
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return n;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        throw new SQLException("No misfired trigger count returned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectMisfiredTriggersInGroupInState(Connection conn, String groupName, String state, long ts) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC"));
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            ps.setString(2, groupName);
            ps.setString(3, state);
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>();
            while (rs.next()) {
                String triggerName = rs.getString("TRIGGER_NAME");
                list.add(new Key(triggerName, groupName));
            }
            Object[] oArr = list.toArray();
            Key[] kArr = new Key[oArr.length];
            System.arraycopy(oArr, 0, kArr, 0, oArr.length);
            Key[] keyArray = kArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] selectTriggersForRecoveringJobs(Connection conn) throws SQLException, IOException, ClassNotFoundException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
            ps.setString(1, this.instanceId);
            this.setBoolean(ps, 2, true);
            rs = ps.executeQuery();
            long dumId = System.currentTimeMillis();
            ArrayList<SimpleTrigger> list = new ArrayList<SimpleTrigger>();
            while (rs.next()) {
                String jobName = rs.getString("JOB_NAME");
                String jobGroup = rs.getString("JOB_GROUP");
                String trigName = rs.getString("TRIGGER_NAME");
                String trigGroup = rs.getString("TRIGGER_GROUP");
                long firedTime = rs.getLong("FIRED_TIME");
                int priority = rs.getInt("PRIORITY");
                SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + this.instanceId + "_" + String.valueOf(dumId++), "RECOVERING_JOBS", new Date(firedTime));
                rcvryTrig.setJobName(jobName);
                rcvryTrig.setJobGroup(jobGroup);
                rcvryTrig.setPriority(priority);
                rcvryTrig.setMisfireInstruction(1);
                JobDataMap jd = this.selectTriggerJobDataMap(conn, trigName, trigGroup);
                jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", trigName);
                jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", trigGroup);
                jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTime));
                rcvryTrig.setJobDataMap(jd);
                list.add(rcvryTrig);
            }
            Object[] oArr = list.toArray();
            Trigger[] tArr = new Trigger[oArr.length];
            System.arraycopy(oArr, 0, tArr, 0, oArr.length);
            Trigger[] triggerArray = tArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return triggerArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteFiredTriggers(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS"));
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteFiredTriggers(Connection conn, String instanceId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?"));
            ps.setString(1, instanceId);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.setString(3, job.getDescription());
            ps.setString(4, job.getJobClass().getName());
            this.setBoolean(ps, 5, job.isDurable());
            this.setBoolean(ps, 6, job.isVolatile());
            this.setBoolean(ps, 7, job.isStateful());
            this.setBoolean(ps, 8, job.requestsRecovery());
            this.setBytes(ps, 9, baos);
            insertResult = ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        if (insertResult > 0) {
            String[] jobListeners = job.getJobListenerNames();
            for (int i = 0; jobListeners != null && i < jobListeners.length; ++i) {
                this.insertJobListener(conn, job, jobListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, job.getDescription());
            ps.setString(2, job.getJobClass().getName());
            this.setBoolean(ps, 3, job.isDurable());
            this.setBoolean(ps, 4, job.isVolatile());
            this.setBoolean(ps, 5, job.isStateful());
            this.setBoolean(ps, 6, job.requestsRecovery());
            this.setBytes(ps, 7, baos);
            ps.setString(8, job.getName());
            ps.setString(9, job.getGroup());
            insertResult = ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        if (insertResult > 0) {
            this.deleteJobListeners(conn, job.getName(), job.getGroup());
            String[] jobListeners = job.getJobListenerNames();
            for (int i = 0; jobListeners != null && i < jobListeners.length; ++i) {
                this.insertJobListener(conn, job, jobListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectTriggerNamesForJob(Connection conn, String jobName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>(10);
            while (rs.next()) {
                String trigName = rs.getString("TRIGGER_NAME");
                String trigGroup = rs.getString("TRIGGER_GROUP");
                list.add(new Key(trigName, trigGroup));
            }
            Object[] oArr = list.toArray();
            Key[] kArr = new Key[oArr.length];
            System.arraycopy(oArr, 0, kArr, 0, oArr.length);
            Key[] keyArray = kArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteJobListeners(Connection conn, String jobName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteJobDetail(Connection conn, String jobName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Deleting job: " + groupName + "." + jobName));
            }
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJobStateful(Connection conn, String jobName, String groupName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT IS_STATEFUL FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (rs.next()) break block3;
                boolean bl = false;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        boolean bl = this.getBoolean(rs, "IS_STATEFUL");
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean jobExists(Connection conn, String jobName, String groupName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                boolean bl = true;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        boolean bl = false;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            this.setBytes(ps, 1, baos);
            ps.setString(2, job.getName());
            ps.setString(3, job.getGroup());
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertJobListener(Connection conn, JobDetail job, String listener) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_LISTENERS (JOB_NAME, JOB_GROUP, JOB_LISTENER) VALUES(?, ?, ?)"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.setString(3, listener);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectJobListeners(Connection conn, String jobName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            ps = conn.prepareStatement(this.rtp("SELECT JOB_LISTENER FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetail selectJobDetail(Connection conn, String jobName, String groupName, ClassLoadHelper loadHelper) throws ClassNotFoundException, IOException, SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            JobDetail job = null;
            if (rs.next()) {
                job = new JobDetail();
                job.setName(rs.getString("JOB_NAME"));
                job.setGroup(rs.getString("JOB_GROUP"));
                job.setDescription(rs.getString("DESCRIPTION"));
                job.setJobClass(loadHelper.loadClass(rs.getString("JOB_CLASS_NAME")));
                job.setDurability(this.getBoolean(rs, "IS_DURABLE"));
                job.setVolatility(this.getBoolean(rs, "IS_VOLATILE"));
                job.setRequestsRecovery(this.getBoolean(rs, "REQUESTS_RECOVERY"));
                Map map = null;
                map = this.canUseProperties() ? this.getMapFromProperties(rs) : (Map)this.getObjectFromBlob(rs, "JOB_DATA");
                if (null != map) {
                    job.setJobDataMap(new JobDataMap(map));
                }
            }
            JobDetail jobDetail = job;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return jobDetail;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMapFromProperties(ResultSet rs) throws ClassNotFoundException, IOException, SQLException {
        InputStream is = (InputStream)this.getJobDetailFromBlob(rs, "JOB_DATA");
        if (is == null) {
            return null;
        }
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
            }
            finally {
                is.close();
            }
        }
        Map map = this.convertFromProperty(properties);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNumJobs(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int count = 0;
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(JOB_NAME)  FROM {0}JOB_DETAILS"));
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectJobGroups(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT DISTINCT(JOB_GROUP) FROM {0}JOB_DETAILS"));
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectJobsInGroup(Connection conn, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_GROUP = ?"));
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        ByteArrayOutputStream baos = null;
        if (trigger.getJobDataMap().size() > 0) {
            baos = this.serializeJobData(trigger.getJobDataMap());
        }
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setString(3, trigger.getJobName());
            ps.setString(4, trigger.getJobGroup());
            this.setBoolean(ps, 5, trigger.isVolatile());
            ps.setString(6, trigger.getDescription());
            if (trigger.getNextFireTime() != null) {
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
            } else {
                ps.setBigDecimal(7, null);
            }
            long prevFireTime = -1L;
            if (trigger.getPreviousFireTime() != null) {
                prevFireTime = trigger.getPreviousFireTime().getTime();
            }
            ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
            ps.setString(9, state);
            if (trigger instanceof SimpleTrigger && !((SimpleTrigger)trigger).hasAdditionalProperties()) {
                ps.setString(10, "SIMPLE");
            } else if (trigger instanceof CronTrigger && !((CronTrigger)trigger).hasAdditionalProperties()) {
                ps.setString(10, "CRON");
            } else {
                ps.setString(10, "BLOB");
            }
            ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
            long endTime = 0L;
            if (trigger.getEndTime() != null) {
                endTime = trigger.getEndTime().getTime();
            }
            ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
            ps.setString(13, trigger.getCalendarName());
            ps.setInt(14, trigger.getMisfireInstruction());
            this.setBytes(ps, 15, baos);
            ps.setInt(16, trigger.getPriority());
            insertResult = ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        if (insertResult > 0) {
            String[] trigListeners = trigger.getTriggerListenerNames();
            for (int i = 0; trigListeners != null && i < trigListeners.length; ++i) {
                this.insertTriggerListener(conn, trigger, trigListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertSimpleTrigger(Connection conn, SimpleTrigger trigger) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}SIMPLE_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)  VALUES(?, ?, ?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setInt(3, trigger.getRepeatCount());
            ps.setBigDecimal(4, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
            ps.setInt(5, trigger.getTimesTriggered());
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertCronTrigger(Connection conn, CronTrigger trigger) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CRON_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES(?, ?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setString(3, trigger.getCronExpression());
            ps.setString(4, trigger.getTimeZone().getID());
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertBlobTrigger(Connection conn, Trigger trigger) throws SQLException, IOException {
        PreparedStatement ps = null;
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(trigger);
            oos.close();
            byte[] buf = os.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(buf);
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}BLOB_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)  VALUES(?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setBinaryStream(3, (InputStream)is, buf.length);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        boolean updateJobData = trigger.getJobDataMap().isDirty();
        ByteArrayOutputStream baos = null;
        if (updateJobData && trigger.getJobDataMap().size() > 0) {
            baos = this.serializeJobData(trigger.getJobDataMap());
        }
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = updateJobData ? conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?")) : conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, trigger.getJobName());
            ps.setString(2, trigger.getJobGroup());
            this.setBoolean(ps, 3, trigger.isVolatile());
            ps.setString(4, trigger.getDescription());
            long nextFireTime = -1L;
            if (trigger.getNextFireTime() != null) {
                nextFireTime = trigger.getNextFireTime().getTime();
            }
            ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
            long prevFireTime = -1L;
            if (trigger.getPreviousFireTime() != null) {
                prevFireTime = trigger.getPreviousFireTime().getTime();
            }
            ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
            ps.setString(7, state);
            if (trigger instanceof SimpleTrigger && !((SimpleTrigger)trigger).hasAdditionalProperties()) {
                ps.setString(8, "SIMPLE");
            } else if (trigger instanceof CronTrigger && !((CronTrigger)trigger).hasAdditionalProperties()) {
                ps.setString(8, "CRON");
            } else {
                ps.setString(8, "BLOB");
            }
            ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
            long endTime = 0L;
            if (trigger.getEndTime() != null) {
                endTime = trigger.getEndTime().getTime();
            }
            ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
            ps.setString(11, trigger.getCalendarName());
            ps.setInt(12, trigger.getMisfireInstruction());
            ps.setInt(13, trigger.getPriority());
            if (updateJobData) {
                this.setBytes(ps, 14, baos);
                ps.setString(15, trigger.getName());
                ps.setString(16, trigger.getGroup());
            } else {
                ps.setString(14, trigger.getName());
                ps.setString(15, trigger.getGroup());
            }
            insertResult = ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        if (insertResult > 0) {
            this.deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
            String[] trigListeners = trigger.getTriggerListenerNames();
            for (int i = 0; trigListeners != null && i < trigListeners.length; ++i) {
                this.insertTriggerListener(conn, trigger, trigListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSimpleTrigger(Connection conn, SimpleTrigger trigger) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}SIMPLE_TRIGGERS SET REPEAT_COUNT = ?, REPEAT_INTERVAL = ?, TIMES_TRIGGERED = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setInt(1, trigger.getRepeatCount());
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
            ps.setInt(3, trigger.getTimesTriggered());
            ps.setString(4, trigger.getName());
            ps.setString(5, trigger.getGroup());
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCronTrigger(Connection conn, CronTrigger trigger) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, trigger.getCronExpression());
            ps.setString(2, trigger.getName());
            ps.setString(3, trigger.getGroup());
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBlobTrigger(Connection conn, Trigger trigger) throws SQLException, IOException {
        int n;
        block3: {
            PreparedStatement ps = null;
            ByteArrayOutputStream os = null;
            try {
                os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(trigger);
                oos.close();
                byte[] buf = os.toByteArray();
                ByteArrayInputStream is = new ByteArrayInputStream(buf);
                ps = conn.prepareStatement(this.rtp("UPDATE {0}BLOB_TRIGGERS SET BLOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setBinaryStream(1, (InputStream)is, buf.length);
                ps.setString(2, trigger.getName());
                ps.setString(3, trigger.getGroup());
                n = ps.executeUpdate();
                this.closeStatement(ps);
                if (os == null) break block3;
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            os.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerExists(Connection conn, String triggerName, String groupName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                boolean bl = true;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        boolean bl = false;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerState(Connection conn, String triggerName, String groupName, String state) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, state);
            ps.setString(2, triggerName);
            ps.setString(3, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerStateFromOtherStates(Connection conn, String triggerName, String groupName, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            ps.setString(1, newState);
            ps.setString(2, triggerName);
            ps.setString(3, groupName);
            ps.setString(4, oldState1);
            ps.setString(5, oldState2);
            ps.setString(6, oldState3);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerStateFromOtherStatesBeforeTime(Connection conn, String newState, String oldState1, String oldState2, long time) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE (TRIGGER_STATE = ? OR TRIGGER_STATE = ?) AND NEXT_FIRE_TIME < ?"));
            ps.setString(1, newState);
            ps.setString(2, oldState1);
            ps.setString(3, oldState2);
            ps.setLong(4, time);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerGroupStateFromOtherStates(Connection conn, String groupName, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            ps.setString(1, newState);
            ps.setString(2, groupName);
            ps.setString(3, oldState1);
            ps.setString(4, oldState2);
            ps.setString(5, oldState3);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerStateFromOtherState(Connection conn, String triggerName, String groupName, String newState, String oldState) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
            ps.setString(1, newState);
            ps.setString(2, triggerName);
            ps.setString(3, groupName);
            ps.setString(4, oldState);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerGroupStateFromOtherState(Connection conn, String groupName, String newState, String oldState) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
            ps.setString(1, newState);
            ps.setString(2, groupName);
            ps.setString(3, oldState);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerStatesForJob(Connection conn, String jobName, String groupName, String state) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, state);
            ps.setString(2, jobName);
            ps.setString(3, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTriggerStatesForJobFromOtherState(Connection conn, String jobName, String groupName, String state, String oldState) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ? AND TRIGGER_STATE = ?"));
            ps.setString(1, state);
            ps.setString(2, jobName);
            ps.setString(3, groupName);
            ps.setString(4, oldState);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteTriggerListeners(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertTriggerListener(Connection conn, Trigger trigger, String listener) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGER_LISTENERS (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER) VALUES(?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setString(3, listener);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectTriggerListeners(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_LISTENER FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSimpleTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteCronTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteBlobTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNumTriggersForJob(Connection conn, String jobName, String groupName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                int n = rs.getInt(1);
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return n;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        int n = 0;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetail selectJobForTrigger(Connection conn, String triggerName, String groupName, ClassLoadHelper loadHelper) throws ClassNotFoundException, SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT J.JOB_NAME, J.JOB_GROUP, J.IS_DURABLE, J.JOB_CLASS_NAME, J.REQUESTS_RECOVERY FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_NAME = ? AND T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                JobDetail job = new JobDetail();
                job.setName(rs.getString(1));
                job.setGroup(rs.getString(2));
                job.setDurability(this.getBoolean(rs, 3));
                job.setJobClass(loadHelper.loadClass(rs.getString(4)));
                job.setRequestsRecovery(this.getBoolean(rs, 5));
                JobDetail jobDetail = job;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return jobDetail;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No job for trigger '" + groupName + "." + triggerName + "'."));
        }
        JobDetail jobDetail = null;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return jobDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] selectTriggersForJob(Connection conn, String jobName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        ArrayList<Trigger> trigList = new ArrayList<Trigger>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            while (rs.next()) {
                Trigger t = this.selectTrigger(conn, rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP"));
                if (t == null) continue;
                trigList.add(t);
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] selectTriggersForCalendar(Connection conn, String calName) throws SQLException, ClassNotFoundException, IOException {
        ArrayList<Trigger> trigList = new ArrayList<Trigger>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?"));
            ps.setString(1, calName);
            rs = ps.executeQuery();
            while (rs.next()) {
                trigList.add(this.selectTrigger(conn, rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectStatefulJobsOfTriggerGroup(Connection conn, String groupName) throws SQLException {
        ArrayList<Key> jobList = new ArrayList<Key>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT DISTINCT J.JOB_NAME, J.JOB_GROUP FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP AND J.IS_STATEFUL = ?"));
            ps.setString(1, groupName);
            this.setBoolean(ps, 2, true);
            rs = ps.executeQuery();
            while (rs.next()) {
                jobList.add(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        return jobList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger selectTrigger(Connection conn, String triggerName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Trigger trigger = null;
            ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (rs.next()) {
                String jobName = rs.getString("JOB_NAME");
                String jobGroup = rs.getString("JOB_GROUP");
                boolean volatility = this.getBoolean(rs, "IS_VOLATILE");
                String description = rs.getString("DESCRIPTION");
                long nextFireTime = rs.getLong("NEXT_FIRE_TIME");
                long prevFireTime = rs.getLong("PREV_FIRE_TIME");
                String triggerType = rs.getString("TRIGGER_TYPE");
                long startTime = rs.getLong("START_TIME");
                long endTime = rs.getLong("END_TIME");
                String calendarName = rs.getString("CALENDAR_NAME");
                int misFireInstr = rs.getInt("MISFIRE_INSTR");
                int priority = rs.getInt("PRIORITY");
                Map map = null;
                map = this.canUseProperties() ? this.getMapFromProperties(rs) : (Map)this.getObjectFromBlob(rs, "JOB_DATA");
                Date nft = null;
                if (nextFireTime > 0L) {
                    nft = new Date(nextFireTime);
                }
                Date pft = null;
                if (prevFireTime > 0L) {
                    pft = new Date(prevFireTime);
                }
                Date startTimeD = new Date(startTime);
                Date endTimeD = null;
                if (endTime > 0L) {
                    endTimeD = new Date(endTime);
                }
                rs.close();
                ps.close();
                if (triggerType.equals("SIMPLE")) {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    ps.setString(1, triggerName);
                    ps.setString(2, groupName);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        int repeatCount = rs.getInt("REPEAT_COUNT");
                        long repeatInterval = rs.getLong("REPEAT_INTERVAL");
                        int timesTriggered = rs.getInt("TIMES_TRIGGERED");
                        SimpleTrigger st = new SimpleTrigger(triggerName, groupName, jobName, jobGroup, startTimeD, endTimeD, repeatCount, repeatInterval);
                        st.setCalendarName(calendarName);
                        st.setMisfireInstruction(misFireInstr);
                        st.setTimesTriggered(timesTriggered);
                        st.setVolatility(volatility);
                        st.setNextFireTime(nft);
                        st.setPreviousFireTime(pft);
                        st.setDescription(description);
                        st.setPriority(priority);
                        if (null != map) {
                            st.setJobDataMap(new JobDataMap(map));
                        }
                        trigger = st;
                    }
                } else if (triggerType.equals("CRON")) {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    ps.setString(1, triggerName);
                    ps.setString(2, groupName);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        String cronExpr = rs.getString("CRON_EXPRESSION");
                        String timeZoneId = rs.getString("TIME_ZONE_ID");
                        Trigger ct = null;
                        try {
                            TimeZone timeZone = null;
                            if (timeZoneId != null) {
                                timeZone = TimeZone.getTimeZone(timeZoneId);
                            }
                            ct = new CronTrigger(triggerName, groupName, jobName, jobGroup, startTimeD, endTimeD, cronExpr, timeZone);
                        }
                        catch (Exception neverHappens) {
                            // empty catch block
                        }
                        if (null != ct) {
                            ct.setCalendarName(calendarName);
                            ct.setMisfireInstruction(misFireInstr);
                            ct.setVolatility(volatility);
                            ((CronTrigger)ct).setNextFireTime(nft);
                            ((CronTrigger)ct).setPreviousFireTime(pft);
                            ct.setDescription(description);
                            ct.setPriority(priority);
                            if (null != map) {
                                ct.setJobDataMap(new JobDataMap(map));
                            }
                            trigger = ct;
                        }
                    }
                } else if (triggerType.equals("BLOB")) {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    ps.setString(1, triggerName);
                    ps.setString(2, groupName);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        trigger = (Trigger)this.getObjectFromBlob(rs, "BLOB_DATA");
                    }
                } else {
                    throw new ClassNotFoundException("class for trigger type '" + triggerType + "' not found.");
                }
            }
            Trigger trigger2 = trigger;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return trigger2;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDataMap selectTriggerJobDataMap(Connection conn, String triggerName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Object trigger = null;
            ps = conn.prepareStatement(this.rtp("SELECT JOB_DATA FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (rs.next()) {
                Map map = null;
                map = this.canUseProperties() ? this.getMapFromProperties(rs) : (Map)this.getObjectFromBlob(rs, "JOB_DATA");
                rs.close();
                ps.close();
                if (null != map) {
                    JobDataMap jobDataMap = new JobDataMap(map);
                    this.closeResultSet(rs);
                    this.closeStatement(ps);
                    return jobDataMap;
                }
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        return new JobDataMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectTriggerState(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String state = null;
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_STATE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            state = rs.next() ? rs.getString("TRIGGER_STATE") : "DELETED";
            String string = state.intern();
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return string;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerStatus selectTriggerStatus(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            TriggerStatus status = null;
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_STATE, NEXT_FIRE_TIME, JOB_NAME, JOB_GROUP FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (rs.next()) {
                String state = rs.getString("TRIGGER_STATE");
                long nextFireTime = rs.getLong("NEXT_FIRE_TIME");
                String jobName = rs.getString("JOB_NAME");
                String jobGroup = rs.getString("JOB_GROUP");
                Date nft = null;
                if (nextFireTime > 0L) {
                    nft = new Date(nextFireTime);
                }
                status = new TriggerStatus(state, nft);
                status.setKey(new Key(triggerName, groupName));
                status.setJobKey(new Key(jobName, jobGroup));
            }
            TriggerStatus triggerStatus = status;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return triggerStatus;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNumTriggers(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int count = 0;
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS"));
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectTriggerGroups(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS"));
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectTriggersInGroup(Connection conn, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?"));
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertPausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            int rows;
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}PAUSED_TRIGGER_GRPS (TRIGGER_GROUP) VALUES(?)"));
            ps.setString(1, groupName);
            int n = rows = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deletePausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        PreparedStatement ps = null;
        try {
            int rows;
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?"));
            ps.setString(1, groupName);
            int n = rows = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteAllPausedTriggerGroups(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        try {
            int rows;
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS"));
            int n = rows = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTriggerGroupPaused(Connection conn, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?"));
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            boolean bl = rs.next();
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistingTriggerGroup(Connection conn, String groupName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?"));
                ps.setString(1, groupName);
                rs = ps.executeQuery();
                if (rs.next()) break block3;
                boolean bl = false;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        boolean bl = rs.getInt(1) > 0;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
            ps.setString(1, calendarName);
            this.setBytes(ps, 2, baos);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
            this.setBytes(ps, 1, baos);
            ps.setString(2, calendarName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calendarExists(Connection conn, String calendarName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE CALENDAR_NAME = ?"));
                ps.setString(1, calendarName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                boolean bl = true;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        boolean bl = false;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar selectCalendar(Connection conn, String calendarName) throws ClassNotFoundException, IOException, SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String selCal = this.rtp("SELECT * FROM {0}CALENDARS WHERE CALENDAR_NAME = ?");
            ps = conn.prepareStatement(selCal);
            ps.setString(1, calendarName);
            rs = ps.executeQuery();
            Calendar cal = null;
            if (rs.next()) {
                cal = (Calendar)this.getObjectFromBlob(rs, "CALENDAR");
            }
            if (null == cal) {
                this.logger.warn((Object)("Couldn't find calendar with name '" + calendarName + "'."));
            }
            Calendar calendar = cal;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return calendar;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calendarIsReferenced(Connection conn, String calendarName) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?"));
                ps.setString(1, calendarName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                boolean bl = true;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        boolean bl = false;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteCalendar(Connection conn, String calendarName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}CALENDARS WHERE CALENDAR_NAME = ?"));
            ps.setString(1, calendarName);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNumCalendars(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int count = 0;
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(CALENDAR_NAME)  FROM {0}CALENDARS"));
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectCalendars(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS"));
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            Object[] oArr = list.toArray();
            String[] sArr = new String[oArr.length];
            System.arraycopy(oArr, 0, sArr, 0, oArr.length);
            String[] stringArray = sArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long selectNextFireTime(Connection conn) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT MIN(NEXT_FIRE_TIME) AS ALIAS_NXT_FR_TM FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME >= 0"));
                ps.setString(1, "WAITING");
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                long l = rs.getLong("ALIAS_NXT_FR_TM");
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return l;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        long l = 0L;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key selectTriggerForFireTime(Connection conn, long fireTime) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME = ?"));
                ps.setString(1, "WAITING");
                ps.setBigDecimal(2, new BigDecimal(String.valueOf(fireTime)));
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                Key key = new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP"));
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return key;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        Key key = null;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Key> nextTriggers = new LinkedList<Key>();
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME < ? AND (NEXT_FIRE_TIME >= ?) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            ps.setFetchSize(5);
            ps.setMaxRows(5);
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(noLaterThan)));
            ps.setBigDecimal(3, new BigDecimal(String.valueOf(noEarlierThan)));
            rs = ps.executeQuery();
            while (rs.next() && nextTriggers.size() < 5) {
                nextTriggers.add(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
            }
            LinkedList<Key> linkedList = nextTriggers;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return linkedList;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail job) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY, PRIORITY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, trigger.getFireInstanceId());
            ps.setString(2, trigger.getName());
            ps.setString(3, trigger.getGroup());
            this.setBoolean(ps, 4, trigger.isVolatile());
            ps.setString(5, this.instanceId);
            ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
            ps.setString(7, state);
            if (job != null) {
                ps.setString(8, trigger.getJobName());
                ps.setString(9, trigger.getJobGroup());
                this.setBoolean(ps, 10, job.isStateful());
                this.setBoolean(ps, 11, job.requestsRecovery());
            } else {
                ps.setString(8, null);
                ps.setString(9, null);
                this.setBoolean(ps, 10, false);
                this.setBoolean(ps, 11, false);
            }
            ps.setInt(12, trigger.getPriority());
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectFiredTriggerRecords(Connection conn, String triggerName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            LinkedList<FiredTriggerRecord> lst = new LinkedList<FiredTriggerRecord>();
            if (triggerName != null) {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
            } else {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_GROUP = ?"));
                ps.setString(1, groupName);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FiredTriggerRecord rec = new FiredTriggerRecord();
                rec.setFireInstanceId(rs.getString("ENTRY_ID"));
                rec.setFireInstanceState(rs.getString("STATE"));
                rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
                rec.setPriority(rs.getInt("PRIORITY"));
                rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                rec.setTriggerIsVolatile(this.getBoolean(rs, "IS_VOLATILE"));
                rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                if (!rec.getFireInstanceState().equals("ACQUIRED")) {
                    rec.setJobIsStateful(this.getBoolean(rs, "IS_STATEFUL"));
                    rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                    rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                }
                lst.add(rec);
            }
            LinkedList<FiredTriggerRecord> linkedList = lst;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return linkedList;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectFiredTriggerRecordsByJob(Connection conn, String jobName, String groupName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            LinkedList<FiredTriggerRecord> lst = new LinkedList<FiredTriggerRecord>();
            if (jobName != null) {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
            } else {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_GROUP = ?"));
                ps.setString(1, groupName);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FiredTriggerRecord rec = new FiredTriggerRecord();
                rec.setFireInstanceId(rs.getString("ENTRY_ID"));
                rec.setFireInstanceState(rs.getString("STATE"));
                rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
                rec.setPriority(rs.getInt("PRIORITY"));
                rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                rec.setTriggerIsVolatile(this.getBoolean(rs, "IS_VOLATILE"));
                rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                if (!rec.getFireInstanceState().equals("ACQUIRED")) {
                    rec.setJobIsStateful(this.getBoolean(rs, "IS_STATEFUL"));
                    rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                    rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                }
                lst.add(rec);
            }
            LinkedList<FiredTriggerRecord> linkedList = lst;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return linkedList;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectInstancesFiredTriggerRecords(Connection conn, String instanceName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            LinkedList<FiredTriggerRecord> lst = new LinkedList<FiredTriggerRecord>();
            ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?"));
            ps.setString(1, instanceName);
            rs = ps.executeQuery();
            while (rs.next()) {
                FiredTriggerRecord rec = new FiredTriggerRecord();
                rec.setFireInstanceId(rs.getString("ENTRY_ID"));
                rec.setFireInstanceState(rs.getString("STATE"));
                rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
                rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                rec.setTriggerIsVolatile(this.getBoolean(rs, "IS_VOLATILE"));
                rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                if (!rec.getFireInstanceState().equals("ACQUIRED")) {
                    rec.setJobIsStateful(this.getBoolean(rs, "IS_STATEFUL"));
                    rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                    rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                }
                rec.setPriority(rs.getInt("PRIORITY"));
                lst.add(rec);
            }
            LinkedList<FiredTriggerRecord> linkedList = lst;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return linkedList;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set selectFiredTriggerInstanceNames(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            HashSet<String> instanceNames = new HashSet<String>();
            ps = conn.prepareStatement(this.rtp("SELECT DISTINCT INSTANCE_NAME FROM {0}FIRED_TRIGGERS"));
            rs = ps.executeQuery();
            while (rs.next()) {
                instanceNames.add(rs.getString("INSTANCE_NAME"));
            }
            HashSet<String> hashSet = instanceNames;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteFiredTrigger(Connection conn, String entryId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE ENTRY_ID = ?"));
            ps.setString(1, entryId);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectJobExecutionCount(Connection conn, String jobName, String jobGroup) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, jobGroup);
            rs = ps.executeQuery();
            int n = rs.next() ? rs.getInt(1) : 0;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?"));
            this.setBoolean(ps, 1, true);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertSchedulerState(Connection conn, String instanceId, long checkInTime, long interval) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}SCHEDULER_STATE (INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL) VALUES(?, ?, ?)"));
            ps.setString(1, instanceId);
            ps.setLong(2, checkInTime);
            ps.setLong(3, interval);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSchedulerState(Connection conn, String instanceId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?"));
            ps.setString(1, instanceId);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSchedulerState(Connection conn, String instanceId, long checkInTime) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}SCHEDULER_STATE SET LAST_CHECKIN_TIME = ? WHERE INSTANCE_NAME = ?"));
            ps.setLong(1, checkInTime);
            ps.setString(2, instanceId);
            int n = ps.executeUpdate();
            this.closeStatement(ps);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectSchedulerStateRecords(Connection conn, String instanceId) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            LinkedList<SchedulerStateRecord> lst = new LinkedList<SchedulerStateRecord>();
            if (instanceId != null) {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?"));
                ps.setString(1, instanceId);
            } else {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE"));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SchedulerStateRecord rec = new SchedulerStateRecord();
                rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                rec.setCheckinTimestamp(rs.getLong("LAST_CHECKIN_TIME"));
                rec.setCheckinInterval(rs.getLong("CHECKIN_INTERVAL"));
                lst.add(rec);
            }
            LinkedList<SchedulerStateRecord> linkedList = lst;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return linkedList;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    protected final String rtp(String query) {
        return Util.rtp(query, this.tablePrefix);
    }

    protected ByteArrayOutputStream serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (null != obj) {
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.flush();
        }
        return baos;
    }

    protected ByteArrayOutputStream serializeJobData(JobDataMap data) throws IOException {
        if (this.canUseProperties()) {
            return this.serializeProperties(data);
        }
        try {
            return this.serializeObject(data);
        }
        catch (NotSerializableException e) {
            throw new NotSerializableException("Unable to serialize JobDataMap for insertion into database because the value of property '" + this.getKeyOfNonSerializableValue(data) + "' is not serializable: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getKeyOfNonSerializableValue(Map data) {
        for (Map.Entry entry : data.entrySet()) {
            ByteArrayOutputStream baos = null;
            try {
                baos = this.serializeObject(entry.getValue());
            }
            catch (IOException e) {
                Object k = entry.getKey();
                return k;
            }
            finally {
                if (baos == null) continue;
                try {
                    baos.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    private ByteArrayOutputStream serializeProperties(JobDataMap data) throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        if (null != data) {
            Properties properties = this.convertToProperty(data.getWrappedMap());
            properties.store(ba, "");
        }
        return ba;
    }

    protected Map convertFromProperty(Properties properties) throws IOException {
        return new HashMap<Object, Object>(properties);
    }

    protected Properties convertToProperty(Map data) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry entry : data.entrySet()) {
            String val;
            Object key = entry.getKey();
            String string = val = entry.getValue() == null ? "" : entry.getValue();
            if (!(key instanceof String)) {
                throw new IOException("JobDataMap keys/values must be Strings when the 'useProperties' property is set.  offending Key: " + key);
            }
            if (!(val instanceof String)) {
                throw new IOException("JobDataMap values must be Strings when the 'useProperties' property is set.  Key of offending value: " + key);
            }
            properties.put(key, val);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        InputStream binaryInput;
        Object obj = null;
        Blob blobLocator = rs.getBlob(colName);
        if (!(blobLocator == null || blobLocator.length() == 0L || null == (binaryInput = blobLocator.getBinaryStream()) || binaryInput instanceof ByteArrayInputStream && ((ByteArrayInputStream)binaryInput).available() == 0)) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            try {
                obj = in.readObject();
            }
            finally {
                in.close();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?"));
            this.setBoolean(ps, 1, true);
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>();
            while (rs.next()) {
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                list.add(new Key(triggerName, groupName));
            }
            Object[] oArr = list.toArray();
            Key[] kArr = new Key[oArr.length];
            System.arraycopy(oArr, 0, kArr, 0, oArr.length);
            Key[] keyArray = kArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] selectVolatileJobs(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?"));
            this.setBoolean(ps, 1, true);
            rs = ps.executeQuery();
            ArrayList<Key> list = new ArrayList<Key>();
            while (rs.next()) {
                String triggerName = rs.getString("JOB_NAME");
                String groupName = rs.getString("JOB_GROUP");
                list.add(new Key(triggerName, groupName));
            }
            Object[] oArr = list.toArray();
            Key[] kArr = new Key[oArr.length];
            System.arraycopy(oArr, 0, kArr, 0, oArr.length);
            Key[] keyArray = kArr;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return keyArray;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            Blob blobLocator = rs.getBlob(colName);
            if (blobLocator != null) {
                InputStream binaryInput = blobLocator.getBinaryStream();
                return binaryInput;
            }
            return null;
        }
        return this.getObjectFromBlob(rs, colName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set selectPausedTriggerGroups(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> set = new HashSet<String>();
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS"));
            rs = ps.executeQuery();
            while (rs.next()) {
                String groupName = rs.getString("TRIGGER_GROUP");
                set.add(groupName);
            }
            HashSet<String> hashSet = set;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void setBoolean(PreparedStatement ps, int index, boolean val) throws SQLException {
        ps.setBoolean(index, val);
    }

    protected boolean getBoolean(ResultSet rs, String columnName) throws SQLException {
        return rs.getBoolean(columnName);
    }

    protected boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getBoolean(columnIndex);
    }

    protected void setBytes(PreparedStatement ps, int index, ByteArrayOutputStream baos) throws SQLException {
        ps.setBytes(index, baos == null ? new byte[]{} : baos.toByteArray());
    }
}

