/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;

public abstract class AjaxFormSubmitBehavior
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private Form<?> __form;
    private boolean defaultProcessing = true;

    public AjaxFormSubmitBehavior(String event) {
        this(null, event);
    }

    public AjaxFormSubmitBehavior(Form<?> form, String event) {
        super(event);
        this.__form = form;
        if (form != null) {
            form.setOutputMarkupId(true);
        }
    }

    public final Form<?> getForm() {
        if (this.__form == null) {
            this.__form = this.findForm();
            if (this.__form == null) {
                throw new IllegalStateException("form was not specified in the constructor and cannot be found in the hierarchy of the component this behavior is attached to: Component=" + this.getComponent().toString(false));
            }
        }
        return this.__form;
    }

    protected Form<?> findForm() {
        Component component = this.getComponent();
        if (component instanceof Form) {
            return (Form)component;
        }
        return component.findParent(Form.class);
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        Form<?> form = this.getForm();
        attributes.setFormId(form.getMarkupId());
        String formMethod = form.getMarkupAttributes().getString("method");
        if (formMethod == null || "POST".equalsIgnoreCase(formMethod)) {
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }
        if (form.getRootForm().isMultiPart()) {
            attributes.setMultipart(true);
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }
        if (this.getComponent() instanceof IFormSubmittingComponent) {
            String submittingComponentName = ((IFormSubmittingComponent)((Object)this.getComponent())).getInputName();
            attributes.setSubmittingComponentName(submittingComponentName);
        }
    }

    @Override
    protected void onEvent(final AjaxRequestTarget target) {
        this.getForm().getRootForm().onFormSubmitted(new IFormSubmitter(){

            @Override
            public Form<?> getForm() {
                return AjaxFormSubmitBehavior.this.getForm();
            }

            @Override
            public boolean getDefaultFormProcessing() {
                return AjaxFormSubmitBehavior.this.getDefaultProcessing();
            }

            @Override
            public void onError() {
                AjaxFormSubmitBehavior.this.onError(target);
            }

            @Override
            public void onSubmit() {
                AjaxFormSubmitBehavior.this.onSubmit(target);
            }

            @Override
            public void onAfterSubmit() {
                AjaxFormSubmitBehavior.this.onAfterSubmit(target);
            }
        });
    }

    protected void onAfterSubmit(AjaxRequestTarget target) {
    }

    protected void onSubmit(AjaxRequestTarget target) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    @Override
    @Deprecated
    protected CharSequence getPreconditionScript() {
        return null;
    }

    public boolean getDefaultProcessing() {
        return this.defaultProcessing;
    }

    public void setDefaultProcessing(boolean defaultProcessing) {
        this.defaultProcessing = defaultProcessing;
    }
}

