/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;

public class MultiPassIndexSplitter {
    @Deprecated
    public void split(IndexReader input, Directory[] outputs, boolean seq) throws IOException {
        this.split(Version.LUCENE_CURRENT, input, outputs, seq);
    }

    public void split(Version version, IndexReader input, Directory[] outputs, boolean seq) throws IOException {
        if (outputs == null || outputs.length < 2) {
            throw new IOException("Invalid number of outputs.");
        }
        if (input == null || input.numDocs() < 2) {
            throw new IOException("Not enough documents for splitting");
        }
        int numParts = outputs.length;
        input = new FakeDeleteIndexReader((IndexReader)input);
        int maxDoc = input.maxDoc();
        int partLen = maxDoc / numParts;
        for (int i = 0; i < numParts; ++i) {
            input.undeleteAll();
            if (seq) {
                int j;
                int lo = partLen * i;
                int hi = lo + partLen;
                for (j = 0; j < lo; ++j) {
                    input.deleteDocument(j);
                }
                if (i < numParts - 1) {
                    for (j = hi; j < maxDoc; ++j) {
                        input.deleteDocument(j);
                    }
                }
            } else {
                for (int j = 0; j < maxDoc; ++j) {
                    if ((j + numParts - i) % numParts == 0) continue;
                    input.deleteDocument(j);
                }
            }
            IndexWriter w = new IndexWriter(outputs[i], new IndexWriterConfig(version, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_CURRENT)).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
            System.err.println("Writing part " + (i + 1) + " ...");
            w.addIndexes(new IndexReader[]{input});
            w.close();
        }
        System.err.println("Done.");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Usage: MultiPassIndexSplitter -out <outputDir> -num <numParts> [-seq] <inputIndex1> [<inputIndex2 ...]");
            System.err.println("\tinputIndex\tpath to input index, multiple values are ok");
            System.err.println("\t-out ouputDir\tpath to output directory to contain partial indexes");
            System.err.println("\t-num numParts\tnumber of parts to produce");
            System.err.println("\t-seq\tsequential docid-range split (default is round-robin)");
            System.exit(-1);
        }
        ArrayList<IndexReader> indexes = new ArrayList<IndexReader>();
        String outDir = null;
        int numParts = -1;
        boolean seq = false;
        for (int i = 0; i < args.length; ++i) {
            FSDirectory dir;
            block14: {
                if (args[i].equals("-out")) {
                    outDir = args[++i];
                    continue;
                }
                if (args[i].equals("-num")) {
                    numParts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seq")) {
                    seq = true;
                    continue;
                }
                File file = new File(args[i]);
                if (!file.exists() || !file.isDirectory()) {
                    System.err.println("Invalid input path - skipping: " + file);
                    continue;
                }
                dir = FSDirectory.open((File)new File(args[i]));
                try {
                    if (!IndexReader.indexExists((Directory)dir)) {
                        System.err.println("Invalid input index - skipping: " + file);
                    }
                    break block14;
                }
                catch (Exception e) {
                    System.err.println("Invalid input index - skipping: " + file);
                }
                continue;
            }
            indexes.add(IndexReader.open((Directory)dir, (boolean)true));
        }
        if (outDir == null) {
            throw new Exception("Required argument missing: -out outputDir");
        }
        if (numParts < 2) {
            throw new Exception("Invalid value of required argument: -num numParts");
        }
        if (indexes.size() == 0) {
            throw new Exception("No input indexes to process");
        }
        File out = new File(outDir);
        if (!out.mkdirs()) {
            throw new Exception("Can't create output directory: " + out);
        }
        Directory[] dirs = new Directory[numParts];
        for (int i = 0; i < numParts; ++i) {
            dirs[i] = FSDirectory.open((File)new File(out, "part-" + i));
        }
        MultiPassIndexSplitter splitter = new MultiPassIndexSplitter();
        Object input = indexes.size() == 1 ? (IndexReader)indexes.get(0) : new MultiReader(indexes.toArray(new IndexReader[indexes.size()]));
        splitter.split(Version.LUCENE_CURRENT, (IndexReader)input, dirs, seq);
    }

    private static final class FakeDeleteAtomicIndexReader
    extends FilterIndexReader {
        FixedBitSet dels;
        FixedBitSet oldDels;

        public FakeDeleteAtomicIndexReader(IndexReader in) {
            super(in);
            assert (in.getSequentialSubReaders() == null);
            this.dels = new FixedBitSet(in.maxDoc());
            if (in.hasDeletions()) {
                this.oldDels = new FixedBitSet(in.maxDoc());
                for (int i = 0; i < in.maxDoc(); ++i) {
                    if (!in.isDeleted(i)) continue;
                    this.oldDels.set(i);
                }
                this.dels.or(this.oldDels);
            }
        }

        public int numDocs() {
            return this.in.maxDoc() - this.dels.cardinality();
        }

        protected void doUndeleteAll() throws CorruptIndexException, IOException {
            this.dels = new FixedBitSet(this.in.maxDoc());
            if (this.oldDels != null) {
                this.dels.or(this.oldDels);
            }
        }

        protected void doDelete(int n) throws CorruptIndexException, IOException {
            this.dels.set(n);
        }

        public boolean hasDeletions() {
            return this.in.maxDoc() != this.numDocs();
        }

        public boolean isDeleted(int n) {
            return this.dels.get(n);
        }

        public IndexReader[] getSequentialSubReaders() {
            return null;
        }

        public TermPositions termPositions() throws IOException {
            return new FilterIndexReader.FilterTermPositions(this.in.termPositions()){

                public boolean next() throws IOException {
                    boolean res;
                    while ((res = super.next()) && FakeDeleteAtomicIndexReader.this.dels.get(this.doc())) {
                    }
                    return res;
                }
            };
        }
    }

    private static final class FakeDeleteIndexReader
    extends MultiReader {
        public FakeDeleteIndexReader(IndexReader reader) throws IOException {
            super(FakeDeleteIndexReader.initSubReaders(reader));
        }

        private static IndexReader[] initSubReaders(IndexReader reader) throws IOException {
            final ArrayList subs = new ArrayList();
            new ReaderUtil.Gather(reader){

                protected void add(int base, IndexReader r) {
                    subs.add(new FakeDeleteAtomicIndexReader(r));
                }
            }.run();
            return subs.toArray(new IndexReader[subs.size()]);
        }
    }
}

